/*
 * Decompiled with CFR 0.152.
 */
package jasext.root;

import hep.analysis.EventData;
import hep.io.root.util.RootObjectTreeCellRenderer;
import hep.io.root.util.RootObjectTreeModel;
import jas.plugin.NoEventAvailable;
import jas.plugin.PageContext;
import jas.plugin.PageEvent;
import jas.plugin.PageListener;
import jas.plugin.Plugin;
import jas.plugin.RunEvent;
import jas.plugin.RunListener;
import jas.swingstudio.JavaAnalysisStudio;
import jas.util.JASDialog;
import jasext.root.InterfaceBuilderGUI;
import jasext.root.RootEvent;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;

public class RootPlugin
extends Plugin
implements PageListener {
    private PageContext ebContext;
    private JMenuItem browser = new JRadioButtonMenuItem("Show Event Browser");
    private JMenuItem gen = new JMenuItem("Generate Java Interfaces...");
    private static final RootEvent noEvent = new RootEvent();
    private static final JavaAnalysisStudio app = JavaAnalysisStudio.getApp();

    public void init() {
        super.init();
        this.addMenu(new RootMenu());
    }

    void showEventBrowser(boolean show) {
        if (show) {
            if (this.ebContext != null) {
                this.ebContext.requestShow();
            } else {
                RootEventBrowser reb = new RootEventBrowser();
                this.addRunListener(reb);
                JScrollPane browser = new JScrollPane(reb);
                this.ebContext = this.installPage("Event Browser", browser);
                this.ebContext.addPageListener((PageListener)this);
            }
        } else if (!show && this.ebContext != null) {
            this.ebContext.close();
        }
    }

    public void pageChanged(PageEvent pageEvent) {
        if (pageEvent.getSource() == this.ebContext && pageEvent.getID() == 4001) {
            this.ebContext = null;
            this.browser.setSelected(false);
        }
    }

    static class RootEventTreeModel
    extends RootObjectTreeModel {
        RootEventTreeModel(RootEvent e) {
            super(new RootEventNode(e));
        }

        static /* synthetic */ int access$401(TreeNode x0) {
            return RootObjectTreeModel.getIndex(x0);
        }

        static /* synthetic */ TreeNode access$501(TreeNode x0, Object x1, String x2, int x3) {
            return RootObjectTreeModel.getNodeForChild(x0, x1, x2, x3);
        }

        static class RootEventNode
        implements TreeNode {
            private RootEvent event;

            RootEventNode(RootEvent event) {
                this.event = event;
            }

            public TreeNode getParent() {
                return null;
            }

            public int getIndex(TreeNode child) {
                return RootEventTreeModel.access$401(child);
            }

            public Enumeration children() {
                return new Enumeration(this){
                    private int n;
                    private int i;
                    private final /* synthetic */ RootEventNode this$0;
                    {
                        this.this$0 = this$0;
                        this.n = this.this$0.getChildCount();
                        this.i = 0;
                    }

                    public boolean hasMoreElements() {
                        return this.i < this.n;
                    }

                    public Object nextElement() {
                        return this.this$0.getChildAt(this.i++);
                    }
                };
            }

            public boolean getAllowsChildren() {
                return true;
            }

            public boolean isLeaf() {
                return this.event.getNColumns() == 0;
            }

            public int getChildCount() {
                return this.event.getNColumns();
            }

            public TreeNode getChildAt(int index) {
                return RootEventTreeModel.access$501(this, this.event.getObject(index), this.event.getColumnTitle(index), index);
            }

            public String toString() {
                return this.event.getTitle();
            }
        }
    }

    class RootMenu
    extends JMenu
    implements ActionListener {
        RootMenu() {
            super("Root");
            RootPlugin.this.browser.addActionListener(this);
            RootPlugin.this.gen.addActionListener(this);
            this.add(RootPlugin.this.browser);
            this.add(RootPlugin.this.gen);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == RootPlugin.this.browser) {
                RootPlugin.this.showEventBrowser(RootPlugin.this.browser.isSelected());
            } else if (e.getSource() == RootPlugin.this.gen) {
                InterfaceBuilderGUI gui = new InterfaceBuilderGUI();
                JASDialog dlg = new JASDialog(this, gui, app.getFrame(), "Root Interface Builder"){
                    private final /* synthetic */ InterfaceBuilderGUI val$gui;
                    private final /* synthetic */ RootMenu this$1;
                    {
                        this.this$1 = this$1;
                        this.val$gui = val$gui;
                    }

                    public void onOK() {
                        this.val$gui.process();
                    }
                };
                dlg.setOKLabel("Generate");
                dlg.setOKMnemonic('G');
                dlg.setCancelLabel("Close");
                dlg.setCancelMnemonic('C');
                dlg.setContentPane((Container)gui);
                dlg.pack();
                dlg.doModal();
            }
        }
    }

    class RootEventBrowser
    extends JTree
    implements RunListener {
        RootEventBrowser() {
            this.setCellRenderer(new RootObjectTreeCellRenderer());
            this.setEvent();
        }

        public void runStateChanged(RunEvent runEvent) {
            if (runEvent.getID() == 2999) {
                this.setEvent();
            }
        }

        private void setEvent() {
            RootEvent event = noEvent;
            try {
                EventData ed = RootPlugin.this.getCurrentEvent();
                if (ed instanceof RootEvent) {
                    event = (RootEvent)ed;
                }
            }
            catch (NoEventAvailable x) {
                // empty catch block
            }
            RootEventTreeModel model = new RootEventTreeModel(event);
            boolean expand = event.getNColumns() == 1;
            Runnable r = new Runnable(this, model, expand){
                private final /* synthetic */ RootEventTreeModel val$model;
                private final /* synthetic */ boolean val$expand;
                private final /* synthetic */ RootEventBrowser this$1;
                {
                    this.this$1 = this$1;
                    this.val$model = val$model;
                    this.val$expand = val$expand;
                }

                public void run() {
                    this.this$1.setModel(this.val$model);
                    if (this.val$expand) {
                        this.this$1.expandRow(1);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
    }
}

