/*
 * Decompiled with CFR 0.152.
 */
package jasext.root;

import hep.analysis.EndOfDataException;
import hep.analysis.EventData;
import hep.io.root.RootFileReader;
import hep.io.root.interfaces.TBranch;
import hep.io.root.interfaces.TDirectory;
import hep.io.root.interfaces.TH1;
import hep.io.root.interfaces.TKey;
import hep.io.root.interfaces.TLeaf;
import hep.io.root.interfaces.TLeafB;
import hep.io.root.interfaces.TLeafC;
import hep.io.root.interfaces.TLeafF;
import hep.io.root.interfaces.TLeafI;
import hep.io.root.interfaces.TLeafS;
import hep.io.root.interfaces.TObjArray;
import hep.io.root.interfaces.TTree;
import jas.jds.module.AnnotatedEventSource;
import jas.jds.module.ModuleException;
import jas.util.tree.TreeItem;
import jasext.root.RootBranchAdapter;
import jasext.root.RootHistogramAdapter;
import jasext.root.RootTreeAdapter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class RootEventSource
implements AnnotatedEventSource {
    private RootFileReader root;
    private TreeItem[] items;
    private static Vector openFileList = new Vector();
    private static ClassLoader currentClassLoader;
    static /* synthetic */ Class class$hep$analysis$EventData;

    public RootEventSource(String fileName) throws ModuleException {
        try {
            this.root = new RootFileReader(fileName);
            openFileList.add(this.root);
            this.root.setClassLoader(currentClassLoader);
            Vector v = this.buildDirectoryTree(this.root);
            this.items = new TreeItem[v.size()];
            v.copyInto(this.items);
        }
        catch (IOException x) {
            throw new ModuleException("Could not open root file " + fileName, (Throwable)x);
        }
    }

    public void close() {
        if (this.root != null) {
            try {
                try {
                    openFileList.remove(this.root);
                    this.root.close();
                }
                catch (IOException x) {
                    Object var3_2 = null;
                    this.root = null;
                }
                Object var3_1 = null;
                this.root = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.root = null;
                throw throwable;
            }
        }
    }

    public void finalize() {
        this.close();
    }

    public String getName() {
        return this.root.getName();
    }

    public TreeItem[] getItems() {
        return this.items;
    }

    public Object getItem(TreeItem item) {
        try {
            Object obj = this.root;
            String[] path = item.path;
            int i = 0;
            while (i < path.length) {
                if (obj instanceof TDirectory) {
                    TKey key = ((TDirectory)obj).getKeyForTitle(path[i]);
                    obj = key.getObject();
                } else if (obj instanceof TTree) {
                    TTree tree = (TTree)obj;
                    int n = tree.getNBranches();
                    int j = 0;
                    while (j < n) {
                        TBranch branch = tree.getBranch(j);
                        if (branch.getTitle().equals(path[i])) {
                            obj = branch;
                            break;
                        }
                        ++j;
                    }
                } else if (obj instanceof TBranch) {
                    TBranch branch = (TBranch)obj;
                    TObjArray l = branch.getBranches();
                    Iterator it = l.iterator();
                    while (it.hasNext()) {
                        TBranch b = (TBranch)it.next();
                        if (!b.getTitle().equals(path[i])) continue;
                        obj = b;
                        break;
                    }
                }
                ++i;
            }
            if (obj instanceof TH1) {
                return RootHistogramAdapter.create((TH1)obj);
            }
            if (obj instanceof TBranch) {
                return RootBranchAdapter.create((TBranch)obj, item.type);
            }
            if (obj instanceof TTree) {
                return RootTreeAdapter.create((TTree)obj);
            }
            return null;
        }
        catch (IOException x) {
            x.printStackTrace();
            return null;
        }
    }

    public int getTotalNumberOfEvents() {
        return 0;
    }

    public void beforeFirstEvent() {
    }

    public void afterLastEvent() {
    }

    public EventData getNextEvent() throws EndOfDataException {
        throw new EndOfDataException();
    }

    public Class getEventDataClass() {
        return class$hep$analysis$EventData == null ? (class$hep$analysis$EventData = RootEventSource.class$("hep.analysis.EventData")) : class$hep$analysis$EventData;
    }

    private Vector buildDirectoryTree(TDirectory dir) throws IOException {
        Vector result = new Vector();
        String[] path = new String[]{};
        this.buildDirectoryTree(dir, path, result);
        return result;
    }

    private void buildDirectoryTree(TDirectory dir, String[] oldPath, Vector v) throws IOException {
        int depth = oldPath.length;
        String[] path = new String[depth + 1];
        int i = 0;
        while (i < oldPath.length) {
            path[i] = oldPath[i];
            ++i;
        }
        int n = dir.nKeys();
        int i2 = 0;
        while (i2 < n) {
            TKey key = dir.getKey(i2);
            path[depth] = key.getTitle();
            TreeItem item = new TreeItem();
            item.path = (String[])path.clone();
            item.type = "xxx";
            v.addElement(item);
            String rootClass = key.getObjectClass().getClassName();
            if (rootClass.equals("TDirectory")) {
                item.type = "folder";
                item.flags |= 4;
                TDirectory child = (TDirectory)key.getObject();
                this.buildDirectoryTree(child, path, v);
            } else if (rootClass.equals("TTree")) {
                item.type = "eventSourceFolder";
                item.flags |= 4;
                TTree tree = (TTree)key.getObject();
                this.buildDirectoryTree(tree, path, v);
            } else if (rootClass.startsWith("TH1")) {
                item.type = "histogram";
            } else if (rootClass.startsWith("TH2")) {
                item.type = "histogram2D";
            }
            ++i2;
        }
    }

    private void buildDirectoryTree(TTree tree, String[] oldPath, Vector v) throws IOException {
        int depth = oldPath.length;
        String[] path = new String[depth + 1];
        int i = 0;
        while (i < oldPath.length) {
            path[i] = oldPath[i];
            ++i;
        }
        int n = tree.getNBranches();
        int i2 = 0;
        while (i2 < n) {
            TBranch branch = tree.getBranch(i2);
            path[depth] = branch.getTitle();
            TreeItem item = new TreeItem();
            item.path = (String[])path.clone();
            item.type = "xxx";
            TObjArray ll = branch.getLeaves();
            if (ll != null && ll.size() > 0) {
                TLeaf leaf = (TLeaf)ll.get(0);
                if (leaf instanceof TLeafC) {
                    item.type = "string";
                } else if (leaf.getLen() == 1 && leaf.getLeafCount() == null) {
                    if (leaf instanceof TLeafF) {
                        item.type = "float";
                    } else if (leaf instanceof TLeafI) {
                        item.type = "integer";
                    } else if (leaf instanceof TLeafS) {
                        item.type = "integer";
                    } else if (leaf instanceof TLeafB) {
                        item.type = "integer";
                    }
                }
            }
            v.addElement(item);
            this.buildDirectoryTree(branch, path, v);
            ++i2;
        }
    }

    private void buildDirectoryTree(TBranch branch, String[] oldPath, Vector v) throws IOException {
        int depth = oldPath.length;
        String[] path = new String[depth + 1];
        int i = 0;
        while (i < oldPath.length) {
            path[i] = oldPath[i];
            ++i;
        }
        TObjArray l = branch.getBranches();
        Iterator i2 = l.iterator();
        while (i2.hasNext()) {
            TBranch b = (TBranch)i2.next();
            path[depth] = b.getTitle();
            TreeItem item = new TreeItem();
            item.path = (String[])path.clone();
            item.type = "xxx";
            TObjArray ll = b.getLeaves();
            if (ll != null && ll.size() > 0) {
                TLeaf leaf = (TLeaf)ll.get(0);
                if (leaf instanceof TLeafC) {
                    item.type = "string";
                } else if (leaf.getLen() == 1 && leaf.getLeafCount() == null) {
                    if (leaf instanceof TLeafF) {
                        item.type = "float";
                    } else if (leaf instanceof TLeafI) {
                        item.type = "integer";
                    } else if (leaf instanceof TLeafS) {
                        item.type = "integer";
                    } else if (leaf instanceof TLeafB) {
                        item.type = "integer";
                    }
                }
            }
            v.addElement(item);
            this.buildDirectoryTree(b, path, v);
        }
    }

    static Vector openFiles() {
        return openFileList;
    }

    public static void setClassLoader(Object obj) {
        currentClassLoader = obj.getClass().getClassLoader();
        Enumeration e = openFileList.elements();
        while (e.hasMoreElements()) {
            ((RootFileReader)e.nextElement()).setClassLoader(currentClassLoader);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

