/*
 * Decompiled with CFR 0.152.
 */
package jasext.root;

import hep.analysis.AbstractNTupleEventData;
import hep.io.root.interfaces.TBranch;
import hep.io.root.interfaces.TTree;
import jas.util.NestedRuntimeException;
import java.io.IOException;

public class RootEvent
extends AbstractNTupleEventData {
    private TTree tree;
    private int eventNumber;

    RootEvent(TTree tree, int eventNumber) {
        this.tree = tree;
        this.eventNumber = eventNumber;
    }

    RootEvent() {
    }

    int getNColumns() {
        return this.tree == null ? 0 : this.tree.getNBranches();
    }

    String getColumnTitle(int index) {
        return this.tree.getBranch(index).getTitle();
    }

    String getTitle() {
        return this.tree == null ? "No Event" : this.tree.getTitle() + " (entry # " + this.eventNumber + ")";
    }

    public Object getObject(int column) {
        try {
            TBranch branch = this.tree.getBranch(column);
            return branch.getEntry(this.eventNumber);
        }
        catch (IOException x) {
            throw new NestedRuntimeException("Unexpected IO operation reading Root tree", (Throwable)x);
        }
    }

    public Object getObject(String name) {
        try {
            TBranch branch = this.tree.getBranch(name);
            return branch.getEntry(this.eventNumber);
        }
        catch (IOException x) {
            throw new NestedRuntimeException("Unexpected IO operation reading Root tree", (Throwable)x);
        }
    }

    public double getDouble(int column) {
        return ((Number)this.getObject(column)).doubleValue();
    }

    public double getDouble(String name) {
        return ((Number)this.getObject(name)).doubleValue();
    }

    public int getInt(int column) {
        return ((Number)this.getObject(column)).intValue();
    }

    public int getInt(String name) {
        return ((Number)this.getObject(name)).intValue();
    }

    public String getString(int column) {
        return this.getObject(column).toString();
    }

    public String getString(String name) {
        return this.getObject(name).toString();
    }

    public int findColumn(String name) {
        throw new RuntimeException("findColumn Not implemented");
    }
}

