/*
 * Decompiled with CFR 0.152.
 */
package jasext.root;

import hep.io.root.interfaces.TH2F;
import jasext.root.Root2HistogramAdapter;

class Root2FHistogramAdapter
extends Root2HistogramAdapter {
    private TH2F th2f;

    Root2FHistogramAdapter(TH2F rootHisto) {
        super(rootHisto);
        this.th2f = rootHisto;
    }

    public double[][][] rebin(int xbins, double p2, double p3, int ybins, double p6, double p7, boolean p4, boolean p5, boolean p8) {
        double[][] data = new double[xbins][ybins];
        float[] array = this.th2f.getArray();
        int i = 0;
        while (i < xbins) {
            int j = 0;
            while (j < ybins) {
                data[i][j] = array[1 + i + (j + 1) * (xbins + 2)];
                ++j;
            }
            ++i;
        }
        double[] darray = this.rootHisto.getSumw2();
        if (darray != null && darray.length > 0) {
            double[][] error = new double[xbins][ybins];
            int i2 = 0;
            while (i2 < xbins) {
                int j = 0;
                while (j < ybins) {
                    error[i2][j] = darray[1 + j + (i2 + 1) * (ybins + 2)];
                    ++j;
                }
                ++i2;
            }
            return new double[][][]{data, error};
        }
        return new double[][][]{data};
    }
}

