/*
 * Decompiled with CFR 0.152.
 */
package jasext.root;

import hep.io.root.interfaces.TH1;
import jas.hist.HasStatistics;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.Statistics;

abstract class Root1HistogramAdapter
implements Rebinnable1DHistogramData,
HasStatistics,
Statistics {
    protected TH1 rootHisto;

    Root1HistogramAdapter(TH1 rootHisto) {
        this.rootHisto = rootHisto;
    }

    public double getMin() {
        return this.rootHisto.getXaxis().getXmin();
    }

    public double getMax() {
        return this.rootHisto.getXaxis().getXmax();
    }

    public int getBins() {
        return this.rootHisto.getXaxis().getNbins();
    }

    public boolean isRebinnable() {
        return false;
    }

    public int getAxisType() {
        return 1;
    }

    public String[] getAxisLabels() {
        return null;
    }

    public String getTitle() {
        return this.rootHisto.getTitle();
    }

    public Statistics getStatistics() {
        return this;
    }

    public String[] getStatisticNames() {
        return new String[]{"Entries", "Mean", "RMS"};
    }

    private double mean() {
        return this.rootHisto.getTsumwx() / this.rootHisto.getTsumw();
    }

    public double rms() {
        double sumw = this.rootHisto.getTsumw();
        double sumwx = this.rootHisto.getTsumwx();
        double sumwx2 = this.rootHisto.getTsumwx2();
        return Math.sqrt(sumwx2 / sumw - sumwx * sumwx / sumw / sumw);
    }

    public double getStatistic(String name) {
        if (name.equals("Entries")) {
            return this.rootHisto.getEntries();
        }
        if (name.equals("Mean")) {
            return this.mean();
        }
        if (name.equals("RMS")) {
            return this.rms();
        }
        return 0.0;
    }

    public abstract double[][] rebin(int var1, double var2, double var4, boolean var6, boolean var7);
}

