/*
 * Decompiled with CFR 0.152.
 */
package jasext.root;

import hep.io.root.RootClass;
import hep.io.root.RootClassFactory;
import hep.io.root.RootFileReader;
import hep.io.root.interfaces.TStreamerInfo;
import hep.io.root.util.InterfaceBuilder;
import jas.swingstudio.JavaAnalysisStudio;
import jas.util.DocumentOutputStream;
import jas.util.gui.JDirectoryChooser;
import jasext.root.RootEventSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

class InterfaceBuilderGUI
extends JPanel {
    private static final JavaAnalysisStudio app = JavaAnalysisStudio.getApp();
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JLabel jLabel2;
    private JComboBox jComboBox1;
    private JPanel jPanel3;
    private JLabel jLabel1;
    private JTextField jTextField1;
    private JButton jButton1;
    private JCheckBox jCheckBox2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;

    public InterfaceBuilderGUI() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField(40);
        this.jButton1 = new JButton();
        this.jCheckBox2 = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new GridLayout(0, 1));
        this.jPanel2.setBorder(new TitledBorder("Settings"));
        this.jPanel4.setLayout(new FlowLayout(0, 0, 0));
        this.jLabel2.setText("Root File: ");
        this.jPanel4.add(this.jLabel2);
        this.jComboBox1.setModel(new DefaultComboBoxModel(RootEventSource.openFiles()));
        this.jComboBox1.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof RootFileReader) {
                    this.setText(((RootFileReader)value).getName());
                }
                return this;
            }
        });
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InterfaceBuilderGUI.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jComboBox1);
        this.jPanel2.add(this.jPanel4);
        this.jPanel3.setLayout(new BorderLayout());
        this.jLabel1.setText("Output Directory: ");
        this.jPanel3.add((Component)this.jLabel1, "West");
        this.jTextField1.setText(app.getUserProperties().getProperty("jasext.root.dir", System.getProperty("user.home")));
        this.jPanel3.add((Component)this.jTextField1, "Center");
        this.jButton1.setText("Browse...");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InterfaceBuilderGUI.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.jButton1, "East");
        this.jPanel2.add(this.jPanel3);
        this.jCheckBox2.setSelected(app.getUserProperties().getBoolean("jasext.root.open", true));
        this.jCheckBox2.setText("Open Generated Files in Editor");
        this.jPanel2.add(this.jCheckBox2);
        this.add((Component)this.jPanel2, "North");
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setBorder(new TitledBorder("Output"));
        this.jPanel1.setPreferredSize(new Dimension(200, 100));
        this.jTextArea1.setEditable(false);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.jPanel1, "Center");
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        JDirectoryChooser dlg = new JDirectoryChooser(this.jTextField1.getText());
        dlg.setDialogTitle("Output Directory...");
        dlg.setFileFilter((FileFilter)new DirectoryFileFilter());
        int rc = dlg.showDialog((Component)this);
        if (rc == JDirectoryChooser.APPROVE_OPTION) {
            File file = dlg.getSelectedFile();
            this.jTextField1.setText(file.getAbsolutePath());
        }
    }

    void process() {
        Object[] selected = this.jComboBox1.getSelectedObjects();
        if (selected.length == 0) {
            app.error("No Root File open");
        } else {
            RootFileReader rfr = (RootFileReader)selected[0];
            RootClassFactory rcf = rfr.getFactory();
            File base = new File(this.jTextField1.getText());
            InterfaceBuilder ib = new InterfaceBuilder(base);
            PrintStream pw = new PrintStream((OutputStream)new DocumentOutputStream(this.jTextArea1.getDocument()));
            try {
                try {
                    int n = 0;
                    List list = rfr.streamerInfo();
                    Iterator i = list.iterator();
                    while (i.hasNext()) {
                        TStreamerInfo info = (TStreamerInfo)i.next();
                        String name = info.getName();
                        try {
                            Class<?> k = Class.forName("hep.io.root.interfaces." + name);
                        }
                        catch (ClassNotFoundException x) {
                            RootClass rc = rcf.create(name);
                            File f = ib.write(rc);
                            pw.println("Created " + f.getPath());
                            if (this.jCheckBox2.isSelected()) {
                                app.openFile(f);
                            }
                            ++n;
                        }
                    }
                    if (n == 0) {
                        pw.println("No user defined classes");
                    }
                    app.getUserProperties().setString("jasext.root.dir", this.jTextField1.getText());
                    app.getUserProperties().setBoolean("jasext.root.open", this.jCheckBox2.isSelected());
                }
                catch (Throwable x) {
                    app.error("Error running InterfaceBuilder", x);
                    Object var16_18 = null;
                    pw.close();
                }
                Object var16_17 = null;
                pw.close();
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                pw.close();
                throw throwable;
            }
        }
    }

    private class DirectoryFileFilter
    extends FileFilter {
        private DirectoryFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }

        public String getDescription() {
            return null;
        }
    }
}

