/*
 * Decompiled with CFR 0.152.
 */
package jasext.root;

import hep.io.root.interfaces.TBranch;
import jas.hist.Rebinnable1DHistogramData;
import jas.util.NestedRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

class BranchAdapterS
implements Rebinnable1DHistogramData,
Comparator {
    private String[] labels;
    private double[] data;
    private String title;

    BranchAdapterS(TBranch branch) {
        try {
            this.title = branch.getTitle();
            HashMap<Object, int[]> map = new HashMap<Object, int[]>();
            int n = branch.getNEntries();
            int i = 0;
            while (i < n) {
                Object o = branch.getEntry(i);
                int[] count = (int[])map.get(o);
                if (count == null) {
                    count = new int[]{1};
                    map.put(o, count);
                } else {
                    count[0] = count[0] + 1;
                }
                ++i;
            }
            ArrayList entries = new ArrayList(map.entrySet());
            Collections.sort(entries, this);
            int nbins = entries.size();
            this.labels = new String[nbins];
            this.data = new double[nbins];
            int i2 = 0;
            while (i2 < nbins) {
                Map.Entry entry = (Map.Entry)entries.get(i2);
                this.labels[i2] = entry.getKey().toString();
                this.data[i2] = ((int[])entry.getValue())[0];
                ++i2;
            }
        }
        catch (IOException x) {
            throw new NestedRuntimeException("Error reading Root file", (Throwable)x);
        }
    }

    public int getBins() {
        return this.labels.length;
    }

    public int getAxisType() {
        return 2;
    }

    public double getMax() {
        return this.labels.length;
    }

    public double getMin() {
        return 0.0;
    }

    public String getTitle() {
        return this.title;
    }

    public String[] getAxisLabels() {
        return this.labels;
    }

    public double[][] rebin(int nBins, double xMin, double xMax, boolean needErrors, boolean hurry) {
        return new double[][]{this.data};
    }

    public boolean isRebinnable() {
        return false;
    }

    public int compare(Object obj1, Object obj2) {
        Map.Entry es1 = (Map.Entry)obj1;
        Map.Entry es2 = (Map.Entry)obj2;
        int[] c1 = (int[])es1.getValue();
        int[] c2 = (int[])es2.getValue();
        return c1[0] - c2[0];
    }

    public boolean equals(Object obj) {
        return obj.getClass() == this.getClass();
    }
}

