/*
 * Decompiled with CFR 0.152.
 */
package jasext.root;

import hep.io.root.interfaces.TBranch;
import jas.hist.Rebinnable1DHistogramData;
import jas.util.NestedRuntimeException;
import java.io.IOException;

class BranchAdapterF
implements Rebinnable1DHistogramData {
    private TBranch branch;
    private boolean minMaxCalculated = false;
    private double min;
    private double max;

    BranchAdapterF(TBranch b) {
        this.branch = b;
    }

    private void calculateMinMax() {
        try {
            int n = this.branch.getNEntries();
            if (n > 0) {
                this.min = this.max = ((Number)this.branch.getEntry(0)).doubleValue();
            }
            int i = 1;
            while (i < n) {
                double f = ((Number)this.branch.getEntry(i)).doubleValue();
                if (f < this.min) {
                    this.min = f;
                }
                if (f > this.max) {
                    this.max = f;
                }
                ++i;
            }
            this.minMaxCalculated = true;
        }
        catch (IOException x) {
            throw new NestedRuntimeException("Error reading Root file", (Throwable)x);
        }
    }

    public int getBins() {
        return 50;
    }

    public int getAxisType() {
        return 1;
    }

    public double getMax() {
        if (!this.minMaxCalculated) {
            this.calculateMinMax();
        }
        return this.max;
    }

    public double getMin() {
        if (!this.minMaxCalculated) {
            this.calculateMinMax();
        }
        return this.min;
    }

    public String getTitle() {
        return this.branch.getTitle();
    }

    public String[] getAxisLabels() {
        return null;
    }

    public double[][] rebin(int nBins, double xMin, double xMax, boolean needErrors, boolean hurry) {
        try {
            double[] result = new double[nBins];
            int n = this.branch.getNEntries();
            int i = 0;
            while (i < n) {
                int bin;
                double f = ((Number)this.branch.getEntry(i)).doubleValue();
                if (!(f < xMin) && (bin = (int)Math.floor((double)nBins * (f - xMin) / (xMax - xMin))) < nBins) {
                    int n2 = bin;
                    result[n2] = result[n2] + 1.0;
                }
                ++i;
            }
            return new double[][]{result};
        }
        catch (IOException x) {
            throw new NestedRuntimeException("Error reading Root file", (Throwable)x);
        }
    }

    public boolean isRebinnable() {
        return true;
    }
}

