/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.util;

import hep.io.root.RootClass;
import hep.io.root.RootMember;
import hep.io.root.interfaces.RootObject;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class RootObjectTreeModel
extends DefaultTreeModel {
    public RootObjectTreeModel(Object top, String name) {
        super(RootObjectTreeNode.getNodeForValue(null, top, name, 0));
    }

    protected RootObjectTreeModel(TreeNode node) {
        super(node);
    }

    protected static TreeNode getNodeForChild(TreeNode parent, Object child, String name, int index) {
        return RootObjectTreeNode.getNodeForValue(parent, child, name, index);
    }

    protected static int getIndex(TreeNode child) {
        return ((RootObjectTreeNode)child).index;
    }

    static class RootArrayNode
    extends RootObjectTreeNode {
        private Object array;
        private String name;

        RootArrayNode(TreeNode parent, Object array, String name, int index) {
            super(parent, index);
            this.array = array;
            this.name = name;
        }

        public int getChildCount() {
            return Array.getLength(this.array);
        }

        public TreeNode getChildAt(int index) {
            return RootObjectTreeNode.getNodeForValue(this, Array.get(this.array, index), "[" + index + "]", index);
        }

        String description() {
            return this.name + " (Array)";
        }
    }

    static class RootListNode
    extends RootObjectTreeNode {
        private List list;
        private String name;

        RootListNode(TreeNode parent, List list, String name, int index) {
            super(parent, index);
            this.list = list;
            this.name = name;
        }

        public int getChildCount() {
            return this.list.size();
        }

        public TreeNode getChildAt(int index) {
            return RootObjectTreeNode.getNodeForValue(this, this.list.get(index), "[" + index + "]", index);
        }

        String description() {
            return this.name + " (List)";
        }
    }

    static class RootObjectNode
    extends RootSubObject {
        private String name;

        RootObjectNode(TreeNode parent, RootObject obj, String name, int index) {
            super(parent, obj, obj.rootClass(), index);
            this.name = name;
        }

        String description() {
            return this.name + " (" + super.description() + ")";
        }
    }

    static class RootSimpleValue
    extends RootObjectTreeNode {
        private Object value;
        private String name;

        RootSimpleValue(TreeNode parent, Object value, String name, int index) {
            super(parent, index);
            this.value = value;
            this.name = name;
        }

        public boolean isLeaf() {
            return true;
        }

        String description() {
            return this.name + " = " + this.value;
        }
    }

    static class RootSubObject
    extends RootObjectTreeNode {
        private RootObject obj;
        private RootClass klass;

        RootSubObject(TreeNode parent, RootObject obj, RootClass klass, int index) {
            super(parent, index);
            this.obj = obj;
            this.klass = klass;
        }

        public int getChildCount() {
            int n = this.klass.getSuperClasses().length;
            return n += this.klass.getMembers().length;
        }

        public TreeNode getChildAt(int index) {
            RootClass[] superClasses = this.klass.getSuperClasses();
            if (index < superClasses.length) {
                return new RootSubObject(this, this.obj, superClasses[index], index);
            }
            RootMember member = this.klass.getMembers()[index - superClasses.length];
            Object value = this.obj.getValue(member.getName());
            RootObjectTreeNode node = RootObjectTreeNode.getNodeForValue(this, value, member.getName(), index);
            node.setToolTip(member.getComment());
            return node;
        }

        String description() {
            return "Class " + this.klass.getClassName();
        }
    }

    static abstract class RootObjectTreeNode
    implements TreeNode {
        private TreeNode parent;
        private int index;
        private String tooltip;

        RootObjectTreeNode(TreeNode parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public int getIndex(TreeNode child) {
            return ((RootObjectTreeNode)child).index;
        }

        public Enumeration children() {
            return new Enumeration(this){
                private int n;
                private int i;
                private final /* synthetic */ RootObjectTreeNode this$0;
                {
                    this.this$0 = this$0;
                    this.n = this.this$0.getChildCount();
                    this.i = 0;
                }

                public boolean hasMoreElements() {
                    return this.i < this.n;
                }

                public Object nextElement() {
                    return this.this$0.getChildAt(this.i++);
                }
            };
        }

        static RootObjectTreeNode getNodeForValue(TreeNode parent, Object value, String name, int index) {
            if (value == null) {
                return new RootSimpleValue(parent, "null", name, index);
            }
            if (value instanceof RootObject) {
                return new RootObjectNode(parent, (RootObject)value, name, index);
            }
            if (value instanceof List) {
                return new RootListNode(parent, (List)value, name, index);
            }
            if (value.getClass().isArray()) {
                return new RootArrayNode(parent, value, name, index);
            }
            return new RootSimpleValue(parent, value, name, index);
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public boolean isLeaf() {
            return false;
        }

        public int getChildCount() {
            return 0;
        }

        public TreeNode getChildAt(int p1) {
            throw new InternalError("getChildAt() called");
        }

        public String toString() {
            return this.description();
        }

        void setToolTip(String value) {
            this.tooltip = value;
        }

        String toolTip() {
            return this.tooltip;
        }

        abstract String description();
    }
}

