/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.util;

import hep.io.root.RootFileReader;
import hep.io.root.interfaces.RootObject;
import hep.io.root.interfaces.TKey;
import hep.io.root.interfaces.TNamed;
import hep.io.root.util.BranchEntry;
import hep.io.root.util.HackedFileSystemView;
import hep.io.root.util.RootDirectoryTreeCellRenderer;
import hep.io.root.util.RootDirectoryTreeModel;
import hep.io.root.util.RootObjectTreeCellRenderer;
import hep.io.root.util.RootObjectTreeModel;
import hep.io.root.util.StreamerInfoBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class RootObjectBrowser
extends JPanel
implements TreeSelectionListener {
    private static final String aboutMessage = "<HTML>RootObjectBrowser $Id: RootObjectBrowser.java,v 1.10 2001/06/04 16:17:53 tonyj Exp $<br>Author: Tony Johnson (tonyj@slac.stanford.edu)";
    private static final TreeModel emptyTree = null;
    private JTree tree = new JTree(emptyTree);
    private JTree objTree;
    private RootFileReader reader;
    private RootMenuBar menuBar;

    public RootObjectBrowser() {
        super(new BorderLayout());
        this.tree.setCellRenderer(new RootDirectoryTreeCellRenderer());
        this.tree.addTreeSelectionListener(this);
        this.objTree = new JTree(emptyTree);
        this.objTree.setCellRenderer(new RootObjectTreeCellRenderer());
        ToolTipManager.sharedInstance().registerComponent(this.objTree);
        JSplitPane split = new JSplitPane(1, new JScrollPane(this.tree), new JScrollPane(this.objTree));
        this.add((Component)split, "Center");
        this.menuBar = new RootMenuBar();
        this.add((Component)this.menuBar, "North");
        this.menuBar.setFileOpen(false);
        this.setPreferredSize(new Dimension(500, 300));
        split.setDividerLocation(245);
        ToolTipManager.sharedInstance().setEnabled(true);
    }

    public void setRootFile(File file) throws IOException {
        Cursor old = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.reader = new RootFileReader(file);
            RootDirectoryTreeModel model = new RootDirectoryTreeModel(this.reader){

                public void handleException(IOException x) {
                    RootObjectBrowser.this.error(x);
                    x.printStackTrace();
                    super.handleException(x);
                }
            };
            this.tree.setModel(model);
            this.tree.setRowHeight(20);
            this.tree.setLargeModel(true);
            this.menuBar.setFileOpen(true);
            Object var5_4 = null;
            this.setCursor(old);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.setCursor(old);
            throw throwable;
        }
    }

    public static void main(String[] argv) throws IOException {
        if (argv.length > 1) {
            RootObjectBrowser.usage();
        }
        if (argv.length == 1 && argv[0].startsWith("-")) {
            RootObjectBrowser.usage();
        }
        JFrame frame = new JFrame("Root Object Browser");
        RootObjectBrowser browser = new RootObjectBrowser();
        if (argv.length == 1) {
            browser.setRootFile(new File(argv[0]));
        }
        frame.setContentPane(browser);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.show();
    }

    private static void usage() {
        System.out.println("java RootObjectBrowser [<file>]");
        System.exit(0);
    }

    public void valueChanged(TreeSelectionEvent event) {
        Cursor old = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            block11: {
                try {
                    TreePath path = this.tree.getSelectionPath();
                    if (path == null) {
                        this.objTree.setModel(emptyTree);
                        break block11;
                    }
                    Object node = path.getLastPathComponent();
                    if (node instanceof BranchEntry) {
                        node = ((BranchEntry)node).getValue();
                    }
                    if (node instanceof TKey) {
                        TKey key = (TKey)node;
                        this.objTree.setModel(new RootObjectTreeModel(key.getObject(), key.getName()));
                        break block11;
                    }
                    if (node instanceof TNamed) {
                        this.objTree.setModel(new RootObjectTreeModel(node, ((TNamed)node).getName()));
                        break block11;
                    }
                    if (node instanceof RootObject) {
                        this.objTree.setModel(new RootObjectTreeModel(node, ""));
                        break block11;
                    }
                    if (node.getClass().isArray()) {
                        this.objTree.setModel(new RootObjectTreeModel(node, ""));
                        break block11;
                    }
                    if (node instanceof List) {
                        this.objTree.setModel(new RootObjectTreeModel(node, ""));
                        break block11;
                    }
                    this.objTree.setModel(emptyTree);
                }
                catch (IOException x) {
                    this.objTree.setModel(emptyTree);
                    x.printStackTrace();
                    this.error(x);
                    Object var7_8 = null;
                    this.setCursor(old);
                }
            }
            Object var7_7 = null;
            this.setCursor(old);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.setCursor(old);
            throw throwable;
        }
    }

    private void error(IOException x) {
        JOptionPane.showMessageDialog(this, x.getMessage(), "Error", 0);
    }

    private void showStreamerInfo() {
        try {
            Comparator sortByName = new Comparator(){

                public int compare(Object a, Object b) {
                    return ((TNamed)a).getName().compareTo(((TNamed)b).getName());
                }

                public boolean equals(Object o) {
                    return o.getClass() == this.getClass();
                }
            };
            ArrayList streamerInfo = new ArrayList(this.reader.streamerInfo());
            Collections.sort(streamerInfo, sortByName);
            StreamerInfoBrowser browser = new StreamerInfoBrowser(streamerInfo);
            JFrame f = new JFrame("Root Streamer Info Browser");
            f.setContentPane(browser);
            f.setDefaultCloseOperation(2);
            f.pack();
            f.show();
        }
        catch (IOException x) {
            this.error(x);
        }
    }

    static /* synthetic */ void access$400(RootObjectBrowser x0) {
        x0.showStreamerInfo();
    }

    private static class RootFileFilter
    extends FileFilter {
        private RootFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".root");
        }

        public String getDescription() {
            return "Root Files (*.root)";
        }
    }

    private class RootHelpMenu
    extends JMenu {
        RootHelpMenu() {
            super("Help");
            this.add(new JMenuItem(this, "About..."){
                private final /* synthetic */ RootHelpMenu this$1;
                {
                    this.this$1 = this$1;
                }

                public void fireActionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(RootHelpMenu.access$500(this.this$1), "<HTML>RootObjectBrowser $Id: RootObjectBrowser.java,v 1.10 2001/06/04 16:17:53 tonyj Exp $<br>Author: Tony Johnson (tonyj@slac.stanford.edu)");
                }
            });
        }

        static /* synthetic */ RootObjectBrowser access$500(RootHelpMenu x0) {
            return x0.RootObjectBrowser.this;
        }
    }

    private class RootToolsMenu
    extends JMenu {
        private JMenuItem view = new JMenuItem(this, "View Streamer Info..."){
            private final /* synthetic */ RootToolsMenu this$1;
            {
                this.this$1 = this$1;
            }

            public void fireActionPerformed(ActionEvent e) {
                RootObjectBrowser.access$400(RootToolsMenu.access$300(this.this$1));
            }
        };

        RootToolsMenu() {
            super("Tools");
            this.add(this.view);
        }

        void setFileOpen(boolean state) {
            this.view.setEnabled(state);
        }

        static /* synthetic */ RootObjectBrowser access$300(RootToolsMenu x0) {
            return x0.RootObjectBrowser.this;
        }
    }

    private class RootFileMenu
    extends JMenu {
        RootFileMenu() {
            super("File");
            this.add(new JMenuItem(this, "Open..."){
                private final /* synthetic */ RootFileMenu this$1;
                {
                    this.this$1 = this$1;
                }

                public void fireActionPerformed(ActionEvent e) {
                    JFileChooser dlg = null;
                    try {
                        if (System.getSecurityManager() != null && System.getProperty("os.name").indexOf("indows") > 0 && System.getProperty("java.version").startsWith("1.3")) {
                            dlg = new JFileChooser("Open Root File...", (FileSystemView)new HackedFileSystemView());
                        }
                    }
                    catch (SecurityException x) {
                        // empty catch block
                    }
                    if (dlg == null) {
                        dlg = new JFileChooser("Open Root File...");
                    }
                    dlg.setFileFilter(new RootFileFilter());
                    int rc = dlg.showOpenDialog(RootFileMenu.access$200(this.this$1));
                    if (rc == 0) {
                        try {
                            RootFileMenu.access$200(this.this$1).setRootFile(dlg.getSelectedFile());
                        }
                        catch (IOException x) {
                            RootObjectBrowser.access$000(RootFileMenu.access$200(this.this$1), x);
                        }
                    }
                }
            });
            this.add(new JMenuItem(this, "Exit"){
                private final /* synthetic */ RootFileMenu this$1;
                {
                    this.this$1 = this$1;
                }

                public void fireActionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }

        static /* synthetic */ RootObjectBrowser access$200(RootFileMenu x0) {
            return x0.RootObjectBrowser.this;
        }
    }

    private class RootMenuBar
    extends JMenuBar {
        private RootToolsMenu tools;

        RootMenuBar() {
            this.add(new RootFileMenu());
            this.tools = new RootToolsMenu();
            this.add(this.tools);
            this.add(new RootHelpMenu());
        }

        void setFileOpen(boolean state) {
            this.tools.setFileOpen(state);
        }
    }
}

