/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.util;

import hep.io.root.RootClass;
import hep.io.root.interfaces.TDirectory;
import hep.io.root.interfaces.TKey;
import hep.io.root.util.FakeTKey;
import java.io.IOException;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class RootHistogramTreeModel
implements TreeModel {
    private TKey top;

    public RootHistogramTreeModel(TDirectory topDir) {
        this.top = new FakeTKey(topDir);
    }

    protected void handleException(IOException x) {
        throw new RuntimeException("IOException reading root file");
    }

    public Object getChild(Object parent, int index) {
        try {
            TKey node = (TKey)parent;
            Object object = node.getObject();
            if (object instanceof TDirectory) {
                TDirectory dir = (TDirectory)object;
                int nKeys = dir.nKeys();
                int i = 0;
                while (i < nKeys) {
                    TKey key = dir.getKey(i);
                    RootClass keyClass = key.getObjectClass();
                    if ((keyClass.instanceOf("TDirectory") || keyClass.instanceOf("TH1")) && index-- == 0) {
                        return key;
                    }
                    ++i;
                }
            }
            return null;
        }
        catch (IOException x) {
            this.handleException(x);
            return null;
        }
    }

    public int getChildCount(Object parent) {
        try {
            TKey node = (TKey)parent;
            TDirectory dir = (TDirectory)node.getObject();
            int nKeys = dir.nKeys();
            int nChildren = 0;
            int i = 0;
            while (i < nKeys) {
                TKey key = dir.getKey(i);
                RootClass keyClass = key.getObjectClass();
                if (keyClass.instanceOf("TDirectory")) {
                    ++nChildren;
                } else if (keyClass.instanceOf("TH1")) {
                    ++nChildren;
                }
                ++i;
            }
            return nChildren;
        }
        catch (IOException x) {
            this.handleException(x);
            return 0;
        }
    }

    public int getIndexOfChild(Object parent, Object child) {
        try {
            TKey node = (TKey)parent;
            TDirectory dir = (TDirectory)node.getObject();
            int nKeys = dir.nKeys();
            int nChildren = 0;
            int i = 0;
            while (i < nKeys) {
                TKey key = dir.getKey(i);
                if (key == child) {
                    return nChildren;
                }
                RootClass keyClass = key.getObjectClass();
                if (keyClass.instanceOf("TDirectory")) {
                    ++nChildren;
                } else if (keyClass.instanceOf("TH1")) {
                    ++nChildren;
                }
                ++i;
            }
            return -1;
        }
        catch (IOException x) {
            this.handleException(x);
            return -1;
        }
    }

    public Object getRoot() {
        return this.top;
    }

    public boolean isLeaf(Object parent) {
        try {
            TKey key = (TKey)parent;
            RootClass rc = key.getObjectClass();
            return !rc.instanceOf("TDirectory");
        }
        catch (IOException x) {
            this.handleException(x);
            return true;
        }
    }

    public void removeTreeModelListener(TreeModelListener p1) {
    }

    public void valueForPathChanged(TreePath p1, Object p2) {
    }

    public void addTreeModelListener(TreeModelListener p1) {
    }
}

