/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.util;

import hep.io.root.RootClass;
import hep.io.root.interfaces.TBranch;
import hep.io.root.interfaces.TBranchClones;
import hep.io.root.interfaces.TDirectory;
import hep.io.root.interfaces.TKey;
import hep.io.root.interfaces.TTree;
import hep.io.root.util.BranchEntry;
import hep.io.root.util.FakeTKey;
import java.io.IOException;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class RootDirectoryTreeModel
implements TreeModel {
    private TKey top;

    public RootDirectoryTreeModel(TDirectory topDir) {
        this.top = new FakeTKey(topDir);
    }

    protected void handleException(IOException x) {
        throw new RuntimeException("IOException reading root file");
    }

    public Object getChild(Object parent, int index) {
        try {
            if (parent instanceof TKey) {
                TKey node = (TKey)parent;
                Object object = node.getObject();
                if (object instanceof TDirectory) {
                    TDirectory dir = (TDirectory)object;
                    return dir.getKey(index);
                }
                TTree tree = (TTree)object;
                return tree.getBranch(index);
            }
            TBranch branch = (TBranch)parent;
            int n = branch.getBranches().size();
            if (index < n) {
                Object p = branch.getBranches().get(index);
                if (p instanceof TBranch) {
                    return p;
                }
                if (p instanceof TBranchClones) {
                    return p;
                }
                return new BranchEntry("????" + p.getClass(), index);
            }
            return new BranchEntry(branch, index, n);
        }
        catch (IOException x) {
            this.handleException(x);
            return new BranchEntry(x, index);
        }
    }

    public int getChildCount(Object parent) {
        try {
            if (parent instanceof TKey) {
                TKey node = (TKey)parent;
                Object object = node.getObject();
                if (object instanceof TDirectory) {
                    TDirectory dir = (TDirectory)object;
                    return dir.nKeys();
                }
                TTree tree = (TTree)object;
                return tree.getNBranches();
            }
            TBranch branch = (TBranch)parent;
            int n = branch.getBranches().size();
            return n += branch.getNEntries();
        }
        catch (IOException x) {
            this.handleException(x);
            return 0;
        }
    }

    public int getIndexOfChild(Object parent, Object child) {
        try {
            if (parent instanceof TKey) {
                TKey node = (TKey)parent;
                Object object = node.getObject();
                if (object instanceof TDirectory) {
                    TDirectory dir = (TDirectory)object;
                    int n = dir.nKeys();
                    int i = 0;
                    while (i < n) {
                        if (dir.getKey(i).equals(child)) {
                            return i;
                        }
                        ++i;
                    }
                    throw new IOException("Could not find " + child + " in " + dir);
                }
                TTree tree = (TTree)object;
                int i = 0;
                while (i < tree.getNBranches()) {
                    if (tree.getBranch(i).equals(child)) {
                        return i;
                    }
                    ++i;
                }
                throw new IOException("Could not find " + child + " in " + tree);
            }
            if (child instanceof BranchEntry) {
                BranchEntry entry = (BranchEntry)child;
                return entry.getIndex();
            }
            TBranch branch = (TBranch)parent;
            int index = branch.getBranches().indexOf(child);
            if (index < 0) {
                System.out.println("Illegal index " + index + " " + child + " " + branch);
            }
            return index;
        }
        catch (IOException x) {
            this.handleException(x);
            return -1;
        }
    }

    public Object getRoot() {
        return this.top;
    }

    public boolean isLeaf(Object parent) {
        try {
            if (parent instanceof TKey) {
                TKey key = (TKey)parent;
                RootClass rc = key.getObjectClass();
                if (rc.instanceOf("TDirectory")) {
                    return false;
                }
                return !rc.instanceOf("TTree");
            }
            return !(parent instanceof TBranch);
        }
        catch (IOException x) {
            this.handleException(x);
            return true;
        }
    }

    public void removeTreeModelListener(TreeModelListener p1) {
    }

    public void valueForPathChanged(TreePath p1, Object p2) {
    }

    public void addTreeModelListener(TreeModelListener p1) {
    }
}

