/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.reps;

import hep.io.root.RootInput;
import hep.io.root.RootObjectRepresentation;
import hep.io.root.implementation.SpecificRootObject;
import java.io.IOException;
import java.util.AbstractList;
import java.util.NoSuchElementException;

public class TObjArray
extends SpecificRootObject {
    private RootObjectRepresentation[] array;
    private int lowerBound;

    public void readMembers(RootInput in, int v) throws IOException {
        if (v > 3) {
            throw new IOException("Version mismatch TObjArray: " + v);
        }
        if (v > 2) {
            this.put("fobject", in.readObject("TObject"));
        }
        if (v > 1) {
            this.put("fname", in.readObject("TString"));
        }
        int nobjects = in.readInt();
        this.lowerBound = in.readInt();
        this.put("fLowerBound", this.lowerBound);
        this.array = new RootObjectRepresentation[nobjects];
        int i = 0;
        while (i < nobjects) {
            this.array[i] = in.readObjectRef();
            ++i;
        }
        this.put("fArray", this.array);
    }

    public void read(RootInput in) throws IOException {
        try {
            int v = in.readVersion(this);
            this.readMembers(in, v);
            in.checkLength(this);
        }
        catch (IOException x) {
            System.err.println("Error occured while reading " + this.getRootClass());
            this.dump();
            throw x;
        }
    }

    public Object createProxy() {
        return new TObjArrayProxy();
    }

    RootObjectRepresentation elementAt(int index) {
        return this.array[index];
    }

    int size() {
        int n = this.array.length;
        while (n > 0 && this.array[n - 1] == null) {
            --n;
        }
        return n;
    }

    void setElementAt(int index, RootObjectRepresentation value) {
        this.array[index] = value;
    }

    private class TObjArrayProxy
    extends AbstractList
    implements hep.io.root.interfaces.TObjArray {
        private int size;

        private TObjArrayProxy() {
            this.size = TObjArray.this.size();
        }

        public int size() {
            return this.size;
        }

        public Object get(int index) {
            if (index < 0 || index >= this.size) {
                throw new NoSuchElementException("index=" + index);
            }
            return TObjArray.this.array[index] == null ? null : TObjArray.this.array[index].getProxy();
        }

        public int getLowerBound() {
            return TObjArray.this.lowerBound;
        }

        public int getUpperBound() {
            return TObjArray.this.lowerBound + TObjArray.this.array.length - 1;
        }

        public Object getElementAt(int index) {
            return this.get(index - TObjArray.this.lowerBound);
        }
    }
}

