/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.reps;

import hep.io.root.RootClass;
import hep.io.root.RootClassNotFound;
import hep.io.root.RootInput;
import hep.io.root.RootObjectRepresentation;
import hep.io.root.implementation.GenericRootClass;
import hep.io.root.implementation.GenericRootObject;
import hep.io.root.implementation.SpecificRootObject;
import java.io.IOException;
import java.util.AbstractList;
import java.util.NoSuchElementException;

public class TClonesArray
extends SpecificRootObject {
    private GenericRootObject[] array;
    private int lowerBound;

    public void read(RootInput in) throws IOException {
        int v = in.readVersion(this);
        if (v > 4) {
            throw new IOException("Version mismatch TClonesArray: " + v);
        }
        if (v > 2) {
            this.put("fobject", in.readObject("TObject"));
        }
        if (v > 1) {
            this.put("fname", in.readObject("TString"));
        }
        RootObjectRepresentation s = in.readObject("TString");
        try {
            RootClass cl = in.getFactory().create(s.toString());
            int nobjects = in.readInt();
            if (nobjects < 0) {
                nobjects = -nobjects;
            }
            this.lowerBound = in.readInt();
            this.put("fLowerBound", this.lowerBound);
            this.array = new GenericRootObject[nobjects];
            int i = 0;
            while (i < nobjects) {
                this.array[i] = (GenericRootObject)cl.newInstance();
                ++i;
            }
            ((GenericRootClass)cl).readClones(in, this.array);
            this.put("fArray", this.array);
        }
        catch (RootClassNotFound x) {
            throw new IOException("TClonesArray class not found: " + s.toString());
        }
        in.checkLength(this);
    }

    public Object createProxy() {
        return new TClonesArrayProxy();
    }

    RootObjectRepresentation elementAt(int index) {
        return this.array[index];
    }

    int size() {
        int n = this.array.length;
        while (n > 0 && this.array[n - 1] == null) {
            --n;
        }
        return n;
    }

    private class TClonesArrayProxy
    extends AbstractList
    implements hep.io.root.interfaces.TClonesArray {
        private int size;

        private TClonesArrayProxy() {
            this.size = TClonesArray.this.size();
        }

        public int size() {
            return this.size;
        }

        public Object get(int index) {
            if (index < 0 || index >= this.size) {
                throw new NoSuchElementException("index=" + index);
            }
            return TClonesArray.this.array[index] == null ? null : TClonesArray.this.array[index].getProxy();
        }

        public int getLowerBound() {
            return TClonesArray.this.lowerBound;
        }

        public int getUpperBound() {
            return TClonesArray.this.lowerBound + TClonesArray.this.array.length - 1;
        }

        public Object getElementAt(int index) {
            return this.get(index - TClonesArray.this.lowerBound);
        }
    }
}

