/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.implementation;

import hep.io.root.RootClass;
import hep.io.root.RootClassFactory;
import hep.io.root.RootClassNotFound;
import hep.io.root.RootInput;
import hep.io.root.RootObjectRepresentation;
import hep.io.root.implementation.GenericRootObject;
import hep.io.root.implementation.IntrinsicRootClass;
import hep.io.root.implementation.StreamerInfo;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class StreamerInfoString
extends StreamerInfo {
    private String description;

    public StreamerInfoString(String description) {
        this.description = description;
    }

    void resolve(RootClassFactory factory) throws RootClassNotFound {
        if (this.description != null) {
            Vector<RootClass> sv = new Vector<RootClass>();
            Vector<MemberString> mv = new Vector<MemberString>();
            StringTokenizer tokenizer = new StringTokenizer(this.description, ";");
            while (tokenizer.hasMoreTokens()) {
                int pos;
                String token = tokenizer.nextToken();
                StringTokenizer t2 = new StringTokenizer(token, " ");
                if (t2.countTokens() == 1) {
                    String className = t2.nextToken();
                    RootClass superClass = factory.create(className);
                    sv.addElement(superClass);
                    continue;
                }
                int index = 1;
                String type = t2.nextToken();
                String name = t2.nextToken();
                boolean pointer = type.endsWith("*");
                if (pointer) {
                    type = type.substring(0, type.length() - 1);
                }
                if ((pos = type.indexOf(91)) > 0) {
                    int l = type.length();
                    index = Integer.parseInt(type.substring(pos + 1, l - 1));
                    type = type.substring(0, pos);
                }
                RootClass memberClass = factory.create(type);
                mv.addElement(new MemberString(memberClass, name, pointer, index));
            }
            this.superClasses = new RootClass[sv.size()];
            sv.copyInto(this.superClasses);
            this.members = new MemberString[mv.size()];
            mv.copyInto(this.members);
            this.description = null;
        }
    }

    int getVersion() {
        return 0;
    }

    int getCheckSum() {
        return 0;
    }

    private class MemberString
    extends StreamerInfo.Member {
        private RootClass type;
        private String name;
        private boolean pointer;
        private int dim;

        MemberString(RootClass type, String name, boolean pointer, int dim) {
            this.type = type;
            this.name = name;
            this.pointer = pointer;
            this.dim = dim;
        }

        boolean isPointer() {
            return this.pointer;
        }

        void read(RootInput in, GenericRootObject obj) throws IOException {
            try {
                if (this.pointer) {
                    RootObjectRepresentation rep = in.readObjectRef();
                    obj.put(this.name, rep);
                } else if (this.dim == 1) {
                    obj.put(this.name, this.type.read(in));
                } else {
                    obj.put(this.name, ((IntrinsicRootClass)this.type).readArray(in, this.dim));
                }
            }
            catch (IOException x) {
                x.printStackTrace();
                System.err.println("Error reading member " + this.name + " of " + obj.getRootClass());
                throw x;
            }
        }

        public String getComment() {
            return null;
        }

        public RootClass getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public int getArrayDim() {
            return this.dim == 1 ? 0 : 1;
        }
    }
}

