/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.implementation;

import hep.io.root.RootClass;
import hep.io.root.RootClassFactory;
import hep.io.root.RootClassNotFound;
import hep.io.root.RootInput;
import hep.io.root.implementation.GenericRootObject;
import hep.io.root.implementation.IntrinsicRootClass;
import hep.io.root.implementation.StreamerInfo;
import hep.io.root.interfaces.TStreamerBasicPointer;
import hep.io.root.interfaces.TStreamerElement;
import hep.io.root.interfaces.TStreamerInfo;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;

class StreamerInfoNew
extends StreamerInfo {
    private TStreamerInfo streamerInfo;
    private int version;
    private int checkSum;
    private static final int kBase = 0;
    private static final int kOffsetL = 20;
    private static final int kOffsetP = 40;
    private static final int kCounter = 6;
    private static final int kChar = 1;
    private static final int kShort = 2;
    private static final int kInt = 3;
    private static final int kLong = 4;
    private static final int kFloat = 5;
    private static final int kDouble = 8;
    private static final int kUChar = 11;
    private static final int kUShort = 12;
    private static final int kUInt = 13;
    private static final int kULong = 14;
    private static final int kObject = 61;
    private static final int kAny = 62;
    private static final int kObjectp = 63;
    private static final int kObjectP = 64;
    private static final int kTString = 65;
    private static final int kTObject = 66;
    private static final int kTNamed = 67;
    private static final int kMissing = 99999;
    private static final int kSkip = 100;
    private static final int kSkipL = 120;
    private static final int kSkipP = 140;
    private static final int kObjectV = 47;
    private static final int kObjectVV = 48;
    private static final int kConv = 200;
    private static final int kConvL = 220;
    private static final int kConvP = 240;
    private static final int kStreamer = 500;
    private static final int kStreamLoop = 501;

    public StreamerInfoNew(TStreamerInfo streamerInfo) {
        this.streamerInfo = streamerInfo;
        this.version = streamerInfo.getClassVersion();
        this.checkSum = streamerInfo.getCheckSum();
    }

    public void resolve(RootClassFactory factory) throws RootClassNotFound {
        if (this.streamerInfo != null) {
            Vector<RootClass> sv = new Vector<RootClass>();
            Vector<MemberNew> mv = new Vector<MemberNew>();
            Iterator i = this.streamerInfo.getElements().iterator();
            while (i.hasNext()) {
                TStreamerElement element = (TStreamerElement)i.next();
                if (element == null) continue;
                String typeName = element.getTypeName();
                System.out.println(element.getName() + " " + typeName);
                if (typeName.equals("BASE")) {
                    String className = element.getName();
                    sv.addElement(factory.create(className));
                    continue;
                }
                mv.addElement(new MemberNew(element, factory));
            }
            this.superClasses = new RootClass[sv.size()];
            sv.copyInto(this.superClasses);
            this.members = new MemberNew[mv.size()];
            mv.copyInto(this.members);
            this.streamerInfo = null;
        }
    }

    public int getVersion() {
        return this.version;
    }

    public int getCheckSum() {
        return this.checkSum;
    }

    private class MemberNew
    extends StreamerInfo.Member {
        private int varType;
        private RootClass varClass;
        private String varName;
        private String varCounter;
        private String varComment;
        private int arrayDim;
        private int length = 1;

        MemberNew(TStreamerElement element, RootClassFactory factory) throws RootClassNotFound {
            this.varName = element.getName();
            this.varComment = element.getTitle();
            this.arrayDim = element.getArrayDim();
            String typeName = element.getTypeName();
            this.varType = element.getType();
            int[] mi = element.getMaxIndex();
            int i = 0;
            while (i < this.arrayDim) {
                this.length *= mi[i];
                ++i;
            }
            if (typeName.endsWith("*")) {
                if (this.varType == 62) {
                    this.varType = 64;
                }
                typeName = typeName.substring(0, typeName.length() - 1);
            }
            this.varClass = factory.create(typeName);
            if (element instanceof TStreamerBasicPointer) {
                this.varCounter = ((TStreamerBasicPointer)element).getCountName();
            }
        }

        public String getComment() {
            return this.varComment;
        }

        public String getName() {
            return this.varName;
        }

        public RootClass getType() {
            return this.varClass;
        }

        public int getArrayDim() {
            return this.arrayDim;
        }

        void read(RootInput in, GenericRootObject obj) throws IOException {
            try {
                switch (this.varType) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 65: 
                    case 66: 
                    case 67: {
                        obj.put(this.varName, this.varClass.read(in));
                        break;
                    }
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 48: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: {
                        byte isArray = in.readByte();
                        if (isArray == 0) break;
                        int l = ((Number)obj.get(this.varCounter)).intValue();
                        IntrinsicRootClass intrinsic = (IntrinsicRootClass)this.varClass;
                        obj.put(this.varName, intrinsic.readArray(in, l));
                        break;
                    }
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 28: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: {
                        IntrinsicRootClass intrinsic = (IntrinsicRootClass)this.varClass;
                        obj.put(this.varName, intrinsic.readArray(in, this.length));
                        break;
                    }
                    case 64: {
                        obj.put(this.varName, in.readObjectRef());
                        break;
                    }
                    default: {
                        throw new IOException("Unable to decode varType " + this.varType);
                    }
                }
            }
            catch (IOException x) {
                System.err.println("Error reading member " + this.varName + " of type " + this.varClass.getClassName());
                throw x;
            }
        }
    }
}

