/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.implementation;

import hep.io.root.RootClassFactory;
import hep.io.root.RootFileReader;
import hep.io.root.RootInput;
import hep.io.root.RootObjectRepresentation;
import hep.io.root.implementation.AbstractRootObject;
import hep.io.root.implementation.RootInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;

public class RootRandomAccessFile
extends RandomAccessFile
implements RootInput {
    private long offset;
    private RootFileReader reader;
    private Hashtable map = new Hashtable();

    public RootRandomAccessFile(File file, RootFileReader reader) throws IOException {
        super(file, "r");
        this.reader = reader;
        if (this.readByte() != 114 || this.readByte() != 111 || this.readByte() != 111 || this.readByte() != 116) {
            throw new IOException("Not a root file: " + file);
        }
    }

    public String readString() throws IOException {
        return RootInputStream.readString(this);
    }

    public String readNullTerminatedString(int maxLength) throws IOException {
        return RootInputStream.readNullTerminatedString(this, maxLength);
    }

    public int readVersion() throws IOException {
        return RootInputStream.readVersion(this, null);
    }

    public int readVersion(AbstractRootObject obj) throws IOException {
        return RootInputStream.readVersion(this, obj);
    }

    public int readArray(int[] data) throws IOException {
        return RootInputStream.readArray((RootInput)this, data);
    }

    public int readArray(byte[] data) throws IOException {
        return RootInputStream.readArray((RootInput)this, data);
    }

    public int readArray(float[] data) throws IOException {
        return RootInputStream.readArray((RootInput)this, data);
    }

    public int readArray(double[] data) throws IOException {
        return RootInputStream.readArray((RootInput)this, data);
    }

    public void checkLength(AbstractRootObject obj) throws IOException {
        RootInputStream.checkLength(this, obj);
    }

    public long getPosition() throws IOException {
        return this.getFilePointer() - this.offset;
    }

    public RootObjectRepresentation readObject(String type) throws IOException {
        return RootInputStream.readObject(this, type);
    }

    public RootObjectRepresentation readObjectRef() throws IOException {
        return RootInputStream.readObjectRef(this, this.map);
    }

    public RootClassFactory getFactory() {
        return this.reader.getFactory();
    }

    public RootRandomAccessFile getRAF() {
        return this;
    }

    public void clearMap() {
        this.map.clear();
        this.offset = 0L;
    }

    public void setMap(int keylen) throws IOException {
        this.offset = this.getFilePointer() - (long)keylen;
    }
}

