/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.implementation;

import hep.io.root.NameMangler;
import hep.io.root.RootClass;
import hep.io.root.RootMember;
import hep.io.root.implementation.AbstractRootObject;
import hep.io.root.interfaces.TBranch;
import java.io.IOException;
import java.lang.reflect.Array;

public abstract class HollowRootObject
extends AbstractRootObject {
    private TBranch branch;
    private int index;
    private int cloneIndex = -1;
    private Object result = null;
    private static final NameMangler nameMangler = NameMangler.instance();

    public void setHollow(TBranch branch) {
        this.branch = branch;
    }

    public void setHollowIndex(int index) {
        this.index = index;
    }

    public void setCloneIndex(int index) {
        this.cloneIndex = index;
    }

    public Object get(String name) {
        if (this.branch == null) {
            return super.get(name);
        }
        try {
            TBranch sub = this.branch.getBranchForName(name);
            if (sub != null) {
                Object result = sub.getEntry(this.index);
                if (this.cloneIndex >= 0 && result.getClass().isArray()) {
                    return Array.get(result, this.cloneIndex);
                }
                return result;
            }
            RootMember[] members = this.getRootClass().getMembers();
            int j = 0;
            while (j < members.length) {
                if (members[j].getName().equals(name)) {
                    RootClass k = members[j].getType();
                    HollowRootObject ho = (HollowRootObject)k.newInstance();
                    ho.setHollow(this.branch);
                    ho.setHollowIndex(this.index);
                    if (this.cloneIndex >= 0) {
                        ho.setCloneIndex(this.cloneIndex);
                    }
                    return ho;
                }
                ++j;
            }
            return null;
        }
        catch (IOException x) {
            x.printStackTrace();
            throw new RuntimeException("IOException while accessing " + name);
        }
    }

    public Object getMangled(String name) {
        if (this.branch == null) {
            return super.getMangled(name);
        }
        try {
            TBranch sub = this.branch.getBranchForMangledName(name);
            if (sub != null) {
                Object result = sub.getEntry(this.index);
                if (this.cloneIndex >= 0 && result.getClass().isArray()) {
                    return Array.get(result, this.cloneIndex);
                }
                return result;
            }
            RootMember[] members = this.getRootClass().getMembers();
            int j = 0;
            while (j < members.length) {
                if (nameMangler.mangleMember(members[j].getName()).equals(name)) {
                    RootClass k = members[j].getType();
                    HollowRootObject ho = (HollowRootObject)k.newInstance();
                    ho.setHollow(this.branch);
                    ho.setHollowIndex(this.index);
                    if (this.cloneIndex >= 0) {
                        ho.setCloneIndex(this.cloneIndex);
                    }
                    return ho;
                }
                ++j;
            }
            return null;
        }
        catch (IOException x) {
            x.printStackTrace();
            throw new RuntimeException("IOException while accessing " + name);
        }
    }
}

