/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.implementation;

import hep.io.root.RootClass;
import hep.io.root.RootInput;
import hep.io.root.RootObjectRepresentation;
import hep.io.root.implementation.GenericRootClass;
import hep.io.root.implementation.HollowRootObject;
import hep.io.root.implementation.StreamerInfo;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class GenericRootObject
extends HollowRootObject
implements InvocationHandler {
    private Object proxy;
    private StreamerInfo streamerInfo;
    private Hashtable methodMap;
    private static Method rootClassMethod;
    private static Method getValueMethod;
    private static Method hashCodeMethod;
    private static Method equalsMethod;
    private static Method toStringMethod;
    private static final int hashcode = 1;
    private static final int equals = 2;
    private static final int tostring = 3;
    private static final int getclass = 4;
    private static final int getvalue = 5;
    private static final Integer HASHCODE;
    private static final Integer EQUALS;
    private static final Integer TOSTRING;
    private static final Integer GETCLASS;
    private static final Integer GETVALUE;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$hep$io$root$interfaces$RootObject;
    static /* synthetic */ Class class$java$lang$String;

    public void init(RootClass rootClass, StreamerInfo info) {
        this.streamerInfo = info;
        super.init(rootClass);
        this.methodMap = ((GenericRootClass)rootClass).getMethodMap();
    }

    protected void readMembers(RootInput in, int version) throws IOException {
        this.streamerInfo.read(in, this);
    }

    protected Object createProxy() {
        return ((GenericRootClass)this.getRootClass()).createProxy(this);
    }

    public Object getProxy() {
        if (this.proxy == null) {
            this.proxy = this.createProxy();
        }
        return this.proxy;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object value = null;
            Object target = this.methodMap.get(method);
            if (target == null) {
                target = this.findTarget(method);
                this.methodMap.put(method, target);
            }
            if (target instanceof Method) {
                Method m = (Method)target;
                Class<?> klass = m.getDeclaringClass();
                if (klass.isInstance(this)) {
                    value = m.invoke((Object)this, args);
                } else {
                    RootObjectRepresentation[] superK = this.getSuperClasses();
                    int i = superK.length;
                    while (i-- > 0) {
                        RootObjectRepresentation o = superK[i];
                        if (!klass.isInstance(o)) continue;
                        value = m.invoke((Object)o, args);
                    }
                }
            } else if (target instanceof Integer) {
                switch ((Integer)target) {
                    case 1: {
                        return this.proxyHashCode(proxy);
                    }
                    case 2: {
                        return this.proxyEquals(proxy, args[0]);
                    }
                    case 3: {
                        return this.proxyToString(proxy);
                    }
                    case 4: {
                        return this.getRootClass();
                    }
                    case 5: {
                        value = this.get(args[0].toString());
                    }
                }
            } else {
                value = this.getMangled(target.toString());
            }
            if (value instanceof GenericRootObject) {
                return ((GenericRootObject)value).getProxy();
            }
            return value;
        }
        catch (IllegalAccessException x) {
            throw new InternalError("Unexpected IllegalAccessException invoking " + method.getName() + " on " + this.getRootClass().getClassName() + " " + x.getMessage());
        }
        catch (InvocationTargetException x) {
            throw x.getTargetException();
        }
    }

    private Object findTarget(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass == (class$java$lang$Object == null ? (class$java$lang$Object = GenericRootObject.class$("java.lang.Object")) : class$java$lang$Object)) {
            if (method.equals(hashCodeMethod)) {
                return HASHCODE;
            }
            if (method.equals(equalsMethod)) {
                return EQUALS;
            }
            if (method.equals(toStringMethod)) {
                return TOSTRING;
            }
            throw new InternalError("unexpected Object method dispatched: " + method);
        }
        if (declaringClass == (class$hep$io$root$interfaces$RootObject == null ? (class$hep$io$root$interfaces$RootObject = GenericRootObject.class$("hep.io.root.interfaces.RootObject")) : class$hep$io$root$interfaces$RootObject)) {
            if (method.equals(rootClassMethod)) {
                return GETCLASS;
            }
            if (method.equals(getValueMethod)) {
                return GETVALUE;
            }
            throw new InternalError("unexpected RootObject method dispatched: " + method);
        }
        try {
            Class<?>[] ptypes = method.getParameterTypes();
            String name = method.getName();
            RootObjectRepresentation klass = this;
            RootObjectRepresentation[] superClasses = this.getSuperClasses();
            int i = superClasses.length;
            while (true) {
                try {
                    return klass.getClass().getMethod(name, ptypes);
                }
                catch (NoSuchMethodException x) {
                    if (--i < 0) {
                        throw x;
                    }
                    klass = superClasses[i];
                    continue;
                }
                break;
            }
        }
        catch (NoSuchMethodException x) {
            return method.getName();
        }
    }

    protected Integer proxyHashCode(Object proxy) {
        return new Integer(System.identityHashCode(proxy));
    }

    protected Boolean proxyEquals(Object proxy, Object other) {
        return proxy == other ? Boolean.TRUE : Boolean.FALSE;
    }

    protected String proxyToString(Object proxy) {
        return "Proxy for " + this.getRootClass().getClassName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HASHCODE = new Integer(1);
        EQUALS = new Integer(2);
        TOSTRING = new Integer(3);
        GETCLASS = new Integer(4);
        GETVALUE = new Integer(5);
        try {
            hashCodeMethod = (class$java$lang$Object == null ? (class$java$lang$Object = GenericRootObject.class$("java.lang.Object")) : class$java$lang$Object).getMethod("hashCode", null);
            equalsMethod = (class$java$lang$Object == null ? (class$java$lang$Object = GenericRootObject.class$("java.lang.Object")) : class$java$lang$Object).getMethod("equals", class$java$lang$Object == null ? (class$java$lang$Object = GenericRootObject.class$("java.lang.Object")) : class$java$lang$Object);
            toStringMethod = (class$java$lang$Object == null ? (class$java$lang$Object = GenericRootObject.class$("java.lang.Object")) : class$java$lang$Object).getMethod("toString", null);
            rootClassMethod = (class$hep$io$root$interfaces$RootObject == null ? (class$hep$io$root$interfaces$RootObject = GenericRootObject.class$("hep.io.root.interfaces.RootObject")) : class$hep$io$root$interfaces$RootObject).getMethod("rootClass", new Class[0]);
            getValueMethod = (class$hep$io$root$interfaces$RootObject == null ? (class$hep$io$root$interfaces$RootObject = GenericRootObject.class$("hep.io.root.interfaces.RootObject")) : class$hep$io$root$interfaces$RootObject).getMethod("getValue", class$java$lang$String == null ? (class$java$lang$String = GenericRootObject.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }
}

