/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.implementation;

import hep.io.root.NameMangler;
import hep.io.root.RootClass;
import hep.io.root.RootClassFactory;
import hep.io.root.RootClassNotFound;
import hep.io.root.RootFileReader;
import hep.io.root.RootInput;
import hep.io.root.RootMember;
import hep.io.root.RootObjectRepresentation;
import hep.io.root.implementation.GenericRootObject;
import hep.io.root.implementation.StreamerInfo;
import hep.io.root.interfaces.RootObject;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import java.util.Vector;

public class GenericRootClass
implements RootClass {
    private Constructor proxyConstructor;
    protected StreamerInfo streamerInfo;
    private String name;
    private Hashtable methodMap = new Hashtable();
    private static final NameMangler nameMangler = NameMangler.instance();
    private RootFileReader rfr;
    static /* synthetic */ Class class$hep$io$root$interfaces$RootObject;
    static /* synthetic */ Class class$java$lang$reflect$InvocationHandler;

    public GenericRootClass(String name, StreamerInfo info, RootFileReader rfr) {
        this.streamerInfo = info;
        this.name = name;
        this.rfr = rfr;
    }

    public void resolve(RootClassFactory factory) throws RootClassNotFound {
        this.streamerInfo.resolve(factory);
    }

    public String getClassName() {
        return this.name;
    }

    public RootObjectRepresentation newInstance() {
        GenericRootObject gen = new GenericRootObject();
        gen.init(this, this.streamerInfo);
        return gen;
    }

    public Object read(RootInput in) throws IOException {
        RootObjectRepresentation obj = this.newInstance();
        obj.read(in);
        return obj;
    }

    public void readClones(RootInput in, GenericRootObject[] obj) throws IOException {
        this.streamerInfo.readClones(in, obj);
    }

    public RootClass[] getSuperClasses() {
        return this.streamerInfo.getSuperClasses();
    }

    public String toString() {
        return "RootClass: " + this.getClassName();
    }

    public boolean instanceOf(RootClass superClass) {
        if (superClass == this) {
            return true;
        }
        RootClass[] classes = this.getSuperClasses();
        int i = 0;
        while (i < classes.length) {
            if (classes[i].instanceOf(superClass)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public RootMember[] getMembers() {
        return this.streamerInfo.getMembers();
    }

    public String getJavaType() {
        return nameMangler.mangleClass(this.name);
    }

    private void addSuperClasses(Vector interFaces, RootClass klass, ClassLoader classLoader) {
        try {
            Class<?> k = Class.forName(klass.getJavaType(), true, classLoader);
            if (interFaces.contains(k)) {
                return;
            }
            if (!k.isInterface() || !(class$hep$io$root$interfaces$RootObject == null ? (class$hep$io$root$interfaces$RootObject = GenericRootClass.class$("hep.io.root.interfaces.RootObject")) : class$hep$io$root$interfaces$RootObject).isAssignableFrom(k)) {
                throw new RuntimeException("Invalid proxy class " + k);
            }
            interFaces.add(k);
        }
        catch (ClassNotFoundException x) {
            // empty catch block
        }
        RootClass[] superClasses = klass.getSuperClasses();
        int i = 0;
        while (i < superClasses.length) {
            this.addSuperClasses(interFaces, superClasses[i], classLoader);
            ++i;
        }
    }

    public RootObject createProxy(InvocationHandler object) {
        try {
            ClassLoader classLoader = this.rfr.getClassLoader();
            if (this.proxyConstructor == null || this.proxyConstructor.getClass().getClassLoader() != classLoader) {
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                Vector<Class> interFaces = new Vector<Class>();
                interFaces.add(class$hep$io$root$interfaces$RootObject == null ? (class$hep$io$root$interfaces$RootObject = GenericRootClass.class$("hep.io.root.interfaces.RootObject")) : class$hep$io$root$interfaces$RootObject);
                this.addSuperClasses(interFaces, this, classLoader);
                Object[] iClass = new Class[interFaces.size()];
                interFaces.copyInto(iClass);
                Class<?> proxyClass = Proxy.getProxyClass(classLoader, iClass);
                this.proxyConstructor = proxyClass.getConstructor(class$java$lang$reflect$InvocationHandler == null ? (class$java$lang$reflect$InvocationHandler = GenericRootClass.class$("java.lang.reflect.InvocationHandler")) : class$java$lang$reflect$InvocationHandler);
            }
            return (RootObject)this.proxyConstructor.newInstance(object);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("Unable to create proxy for " + this.getClassName());
        }
    }

    public int getVersion() {
        return this.streamerInfo.getVersion();
    }

    public int getCheckSum() {
        return this.streamerInfo.getCheckSum();
    }

    Hashtable getMethodMap() {
        return this.methodMap;
    }

    public boolean instanceOf(String className) {
        if (this.name.equals(className)) {
            return true;
        }
        RootClass[] sups = this.getSuperClasses();
        int i = 0;
        while (i < sups.length) {
            if (sups[i].instanceOf(className)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

