/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.implementation;

import hep.io.root.RootClass;
import hep.io.root.RootClassFactory;
import hep.io.root.RootClassNotFound;
import hep.io.root.RootFileReader;
import hep.io.root.implementation.DefaultClassFactory;
import hep.io.root.implementation.GenericRootClass;
import hep.io.root.implementation.SpecificRootClass;
import hep.io.root.implementation.StreamerInfoNew;
import hep.io.root.interfaces.TKey;
import hep.io.root.interfaces.TStreamerInfo;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class FileClassFactory
implements RootClassFactory {
    private RootClassFactory defaultClassFactory;
    private RootFileReader rfr;
    private Hashtable classMap = new Hashtable();

    public FileClassFactory(TKey streamerInfo, RootClassFactory defaultClassFactory, RootFileReader rfr) throws IOException {
        this.defaultClassFactory = defaultClassFactory;
        this.rfr = rfr;
        List tList = (List)streamerInfo.getObject();
        Iterator i = tList.iterator();
        while (i.hasNext()) {
            TStreamerInfo element = (TStreamerInfo)i.next();
            String key = element.getName();
            System.out.println("key=" + key);
            StreamerInfoNew info = new StreamerInfoNew(element);
            Class c = ((DefaultClassFactory)defaultClassFactory).findClass(key);
            if (c != null) {
                this.classMap.put(key, new SpecificRootClass(c, key, info, rfr));
                continue;
            }
            this.classMap.put(key, new GenericRootClass(key, info, rfr));
        }
        Enumeration e = this.classMap.elements();
        while (e.hasMoreElements()) {
            RootClass info = (RootClass)e.nextElement();
            try {
                info.resolve(this);
            }
            catch (RootClassNotFound x) {
                throw new RuntimeException("Could not resolve class " + x.getClassName() + " referenced from " + info.getClassName());
            }
        }
    }

    public RootClass create(String name) throws RootClassNotFound {
        RootClass klass;
        if (name.startsWith("enum")) {
            name = "Int_t";
        }
        if ((klass = (RootClass)this.classMap.get(name)) != null) {
            return klass;
        }
        return this.defaultClassFactory.create(name);
    }
}

