/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.implementation;

import hep.io.root.RootClass;
import hep.io.root.RootClassFactory;
import hep.io.root.RootClassNotFound;
import hep.io.root.RootFileReader;
import hep.io.root.implementation.GenericRootClass;
import hep.io.root.implementation.SpecificRootClass;
import hep.io.root.implementation.StreamerInfoString;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class DefaultClassFactory
implements RootClassFactory {
    private Hashtable classMap = new Hashtable();
    private String[] packageList;
    private RootFileReader rfr;
    static /* synthetic */ Class class$hep$io$root$implementation$IntrinsicRootClass;

    public DefaultClassFactory(RootFileReader rfr) {
        try {
            Properties typedef = new Properties();
            InputStream in = this.getClass().getResourceAsStream("Typedef.properties");
            typedef.load(in);
            in.close();
            Properties streamerInfo = new Properties();
            in = this.getClass().getResourceAsStream("StreamerInfo.properties");
            streamerInfo.load(in);
            in.close();
            String[] classPackages = new String[]{"hep.io.root.reps"};
            this.init(typedef, streamerInfo, classPackages, rfr);
        }
        catch (IOException x) {
            throw new RuntimeException("Unable to load default properties");
        }
    }

    private void init(Properties typedef, Properties streamerInfo, String[] packageList, RootFileReader rfr) {
        Object value;
        Object key;
        Enumeration<Object> e;
        this.packageList = packageList;
        try {
            e = ((Hashtable)typedef).keys();
            while (e.hasMoreElements()) {
                Class<?> intrinsic;
                key = e.nextElement();
                value = ((Hashtable)typedef).get(key);
                if (!(class$hep$io$root$implementation$IntrinsicRootClass == null ? DefaultClassFactory.class$("hep.io.root.implementation.IntrinsicRootClass") : class$hep$io$root$implementation$IntrinsicRootClass).isAssignableFrom(intrinsic = Class.forName("hep.io.root.implementation." + value))) {
                    throw new RuntimeException("Typedef class is not an intrinsic: " + value);
                }
                this.classMap.put(key, intrinsic.newInstance());
            }
        }
        catch (Exception x) {
            throw new RuntimeException("Error interpreting typedef table");
        }
        try {
            e = ((Hashtable)streamerInfo).keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                value = ((Hashtable)streamerInfo).get(key);
                StreamerInfoString info = new StreamerInfoString((String)value);
                Class c = this.findClass((String)key);
                if (c != null) {
                    this.classMap.put(key, new SpecificRootClass(c, (String)key, info, rfr));
                    continue;
                }
                this.classMap.put(key, new GenericRootClass((String)key, info, rfr));
            }
        }
        catch (Exception x) {
            throw new RuntimeException("Error interpreting typedef table");
        }
        try {
            e = this.classMap.elements();
            while (e.hasMoreElements()) {
                RootClass info = (RootClass)e.nextElement();
                info.resolve(this);
            }
        }
        catch (RootClassNotFound x) {
            throw new RuntimeException("Could not resolve class " + x.getClassName());
        }
    }

    public RootClass create(String name) throws RootClassNotFound {
        RootClass result = (RootClass)this.classMap.get(name);
        if (result != null) {
            return result;
        }
        throw new RootClassNotFound(name);
    }

    Class findClass(String name) {
        int i = 0;
        while (i < this.packageList.length) {
            try {
                return Class.forName(this.packageList[i] + "." + name);
            }
            catch (Exception exception) {
                ++i;
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

