/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.implementation;

import hep.io.root.NameMangler;
import hep.io.root.RootClass;
import hep.io.root.RootInput;
import hep.io.root.RootObjectRepresentation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class AbstractRootObject
implements RootObjectRepresentation {
    private long expectedEnd = 0L;
    private int length;
    private Hashtable hash = new Hashtable();
    private Hashtable mangledHash = new Hashtable();
    private static final RootObjectRepresentation[] noSuperClasses = new RootObjectRepresentation[0];
    private RootClass rootClass;
    private RootObjectRepresentation[] superClasses = new RootObjectRepresentation[10];
    private static final NameMangler nameMangler = NameMangler.instance();

    public void init(RootClass rootClass) {
        this.rootClass = rootClass;
        this.superClasses = this.createSuperClasses();
    }

    private RootObjectRepresentation[] createSuperClasses() {
        RootClass[] superClasses = this.rootClass.getSuperClasses();
        if (superClasses.length == 0) {
            return noSuperClasses;
        }
        RootObjectRepresentation[] result = new RootObjectRepresentation[superClasses.length];
        int i = 0;
        while (i < result.length) {
            result[i] = superClasses[i].newInstance();
            ++i;
        }
        return result;
    }

    public void read(RootInput in) throws IOException {
        try {
            int v = in.readVersion(this);
            RootObjectRepresentation[] superClasses = this.getSuperClasses();
            int i = 0;
            while (i < superClasses.length) {
                superClasses[i].read(in);
                ++i;
            }
            this.readMembers(in, v);
            in.checkLength(this);
        }
        catch (IOException x) {
            System.err.println("Error occured while reading " + this.getRootClass());
            this.dump();
            throw x;
        }
    }

    protected abstract void readMembers(RootInput var1, int var2) throws IOException;

    protected void put(String name, Object s) {
        if (s != null) {
            this.hash.put(name, s);
            this.mangledHash.put(nameMangler.mangleMember(name), s);
        }
    }

    public Enumeration members() {
        return this.hash.keys();
    }

    public int nMembers() {
        return this.hash.size();
    }

    public Object get(String name) {
        Object result = this.hash.get(name);
        if (result != null) {
            return result;
        }
        RootObjectRepresentation[] superClasses = this.getSuperClasses();
        int i = superClasses.length - 1;
        while (i >= 0) {
            result = superClasses[i].get(name);
            if (result != null) {
                return result;
            }
            --i;
        }
        return null;
    }

    public Object getMangled(String name) {
        Object result = this.mangledHash.get(name);
        if (result != null) {
            return result;
        }
        RootObjectRepresentation[] superClasses = this.getSuperClasses();
        int i = superClasses.length - 1;
        while (i >= 0) {
            result = superClasses[i].getMangled(name);
            if (result != null) {
                return result;
            }
            --i;
        }
        return null;
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream out) {
        out.println("Object Class " + this.getRootClass());
        Enumeration keys = this.hash.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = this.hash.get(key);
            out.println("  " + key + "=" + value);
        }
    }

    void setExpectedLength(long start, int len) {
        this.length = len;
        this.expectedEnd = start + (long)len;
    }

    void checkLength(long end) throws IOException {
        if (this.expectedEnd != 0L && this.expectedEnd != end) {
            throw new IOException("Error reading " + this.getRootClass().getClassName() + ": Unexpected length (expected " + this.length + " got " + (end - this.expectedEnd + (long)this.length) + ")");
        }
    }

    public RootObjectRepresentation[] getSuperClasses() {
        return this.superClasses;
    }

    public RootClass getRootClass() {
        return this.rootClass;
    }

    public RootObjectRepresentation getSuperClass(String name) {
        if (this.rootClass.getClassName().equals(name)) {
            return this;
        }
        int i = this.superClasses.length;
        while (i-- > 0) {
            if (!this.superClasses[i].getRootClass().getClassName().equals(name)) continue;
            return this.superClasses[i];
        }
        return null;
    }

    public abstract Object getProxy();
}

