/*
 * Decompiled with CFR 0.152.
 */
package jasext.flatfileserver;

import jas.hist.Statistics;
import jasext.flatfileserver.DataColumn;
import jasext.flatfileserver.DateDataColumn;
import jasext.flatfileserver.DoubleDataColumn;
import jasext.flatfileserver.ExponentialFormat;
import jasext.flatfileserver.IntegerDataColumn;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class StringDataColumn
extends DataColumn {
    private Hashtable hashTable = new Hashtable();
    private int valueCount = 0;
    private int index = 0;
    private Vector data = new Vector();
    private String[] currentArray = new String[100];
    private static final int MAXSIZE = 100;
    private int nBins = 0;

    StringDataColumn(String string) {
        super(string);
    }

    void addRow(String string) {
        if (this.index == 100) {
            this.data.addElement(this.currentArray);
            this.index = 0;
            this.currentArray = new String[100];
        }
        this.currentArray[this.index++] = string;
        ++this.valueCount;
        if (string != null) {
            this.hashTable.put(string, this);
        }
    }

    private int getDataType(Format[] formatArray) {
        String string = null;
        ParsePosition parsePosition = new ParsePosition(0);
        int n = 0;
        while (n < formatArray.length) {
            Format format = formatArray[n];
            try {
                Enumeration enumeration = this.hashTable.keys();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    int n2 = string.length();
                    if (n2 == 0) {
                        return formatArray.length;
                    }
                    parsePosition.setIndex(0);
                    format.parseObject(string, parsePosition);
                    if (parsePosition.getIndex() == n2) continue;
                    throw new ParseException("Not all characters used", parsePosition.getIndex());
                }
                break;
            }
            catch (Exception exception) {
                ++n;
            }
        }
        return n;
    }

    DataColumn convert(Format[] formatArray) {
        int n = this.getDataType(formatArray);
        if (n == formatArray.length) {
            return this;
        }
        Format format = formatArray[n];
        if (format instanceof DateFormat) {
            return new DateDataColumn(this, (DateFormat)format);
        }
        if (format instanceof ExponentialFormat) {
            return new DoubleDataColumn(this);
        }
        if (format instanceof NumberFormat) {
            return new IntegerDataColumn(this);
        }
        return this;
    }

    public int getAxisType() {
        return 2;
    }

    public String[] getAxisLabels() {
        if (this.nBins == 0) {
            this.assignBins();
        }
        String[] stringArray = new String[this.nBins];
        Enumeration enumeration = this.hashTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n = (Integer)this.hashTable.get(string);
            stringArray[n] = string;
        }
        return stringArray;
    }

    private void assignBins() {
        Enumeration enumeration = this.hashTable.keys();
        while (enumeration.hasMoreElements()) {
            this.hashTable.put(enumeration.nextElement(), new Integer(this.nBins++));
        }
    }

    public int getBins() {
        return this.nBins;
    }

    public double getMax() {
        return this.nBins;
    }

    public double getMin() {
        return 0.0;
    }

    public boolean isRebinnable() {
        return false;
    }

    public double[][] rebin(int n, double d, double d2, boolean bl, boolean bl2) {
        Object object;
        if (this.nBins == 0) {
            this.assignBins();
        }
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = 0.0;
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.getSize()) {
            object = this.getString(n3);
            Object v = this.hashTable.get(object);
            int n4 = (Integer)v;
            if (n4 >= 0 && n4 < n) {
                int n5 = n4;
                dArray[n5] = dArray[n5] + 1.0;
            }
            ++n3;
        }
        object = new double[][]{dArray};
        return object;
    }

    String getString(int n) {
        int n2 = n / 100;
        if (n2 >= this.data.size()) {
            return this.currentArray[n % 100];
        }
        String[] stringArray = (String[])this.data.elementAt(n2);
        return stringArray[n % 100];
    }

    int getSize() {
        return this.valueCount;
    }

    String getType() {
        return "string";
    }

    public Statistics getStatistics() {
        return null;
    }
}

