/*
 * Decompiled with CFR 0.152.
 */
package jasext.flatfileserver;

import hep.analysis.EventSource;
import jas.jds.module.LocalDIM;
import jas.jds.module.LocalJobBuilder;
import jas.jds.module.ModuleException;
import jas.util.Finishable;
import jas.util.HasHelpPage;
import jas.util.JASDialog;
import jas.util.JASTextField;
import jas.util.JASWizardPage;
import jas.util.OpenLocalFilePanel;
import jas.util.UserProperties;
import jasext.flatfileserver.FlatFileEventSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tablelayout.TableLayout;

public class LocalFlatFileDIM
implements LocalDIM {
    private int m_delim;
    private int m_stringDelimChar;
    private boolean m_firstLineHasTitle;
    private boolean m_hasHeaders;
    private boolean m_gzip;
    private String m_dateTimeFormat;
    private String m_dateFormat;
    private String m_timeFormat;
    private transient LocalJobBuilder m_ljb;
    private transient UserProperties m_prop = UserProperties.getUserProperties();
    private transient FlatFileWizardPage m_wizardPage;
    final int CUSTOM_DELIM = -1;

    public JASWizardPage getSetupPage() {
        this.m_wizardPage = new FlatFileWizardPage();
        return this.m_wizardPage;
    }

    public void setLocalJobBuilder(LocalJobBuilder localJobBuilder) {
        this.m_ljb = localJobBuilder;
    }

    public String toString() {
        return "Flat file";
    }

    public EventSource openDataSet(String string) {
        final FlatFileEventSource flatFileEventSource = new FlatFileEventSource();
        flatFileEventSource.setFileName(string);
        flatFileEventSource.setDelim(this.m_delim);
        flatFileEventSource.setQuoteChar(this.m_stringDelimChar);
        flatFileEventSource.setHasHeaders(this.m_hasHeaders);
        flatFileEventSource.setFirstLineHasTitle(this.m_firstLineHasTitle);
        flatFileEventSource.setLocalJobBuilder(this.m_ljb);
        flatFileEventSource.setGZIP(this.m_gzip);
        flatFileEventSource.setDateTimeFormat(this.m_dateTimeFormat);
        flatFileEventSource.setTimeFormat(this.m_timeFormat);
        flatFileEventSource.setDateFormat(this.m_dateFormat);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    flatFileEventSource.init();
                    if (LocalFlatFileDIM.this.m_wizardPage != null && ((Component)((Object)LocalFlatFileDIM.this.m_wizardPage)).isVisible()) {
                        LocalFlatFileDIM.this.m_wizardPage.dispose();
                    }
                    LocalFlatFileDIM.this.m_ljb.setEventSource((EventSource)flatFileEventSource);
                }
                catch (ModuleException moduleException) {
                    LocalFlatFileDIM.this.m_wizardPage.handleError("Error opening file", moduleException);
                }
            }
        });
        thread.start();
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_prop = UserProperties.getUserProperties();
    }

    private class FlatFileWizardPage
    extends JASWizardPage
    implements Finishable,
    ChangeListener,
    HasHelpPage {
        private JComboBox m_delimiterOption;
        private JASTextField m_custDelimiter;
        private final JLabel m_customDelimiterLabel = new JLabel("Enter custom delimiter: ");
        private JComboBox m_stringDelim;
        private OpenLocalFilePanel m_filePanel;
        private final String[] stringDelimiterStrings = new String[]{"Double Quotation (\")", "Single Quotation (')", "None"};
        private final int[] stringDelimiterChars = new int[]{34, 39, -4};
        private final String[] delimiterStrings = new String[]{"Tab ('\\t')", "Space (' ')", "Comma (',')", "Semi-colon (';')", "Whitespace", "Custom"};
        private final int[] delimiterChars = new int[]{9, 32, 44, 59, -4, -1};
        private final String m_hasHeaders_Key = "HasHeaders";
        private final String m_firstLineHasTitle_Key = "FirstLineHasTitle";
        private final String m_lastDelim_Key = "LastDelim";
        private final String m_lastCustDelimChar_Key = "LastCustDelimChar";
        private final String m_lastStringDelim_Key = "LastStringDelim";
        private final String m_dateTimeFormat_Key = "DateTimeFormat";
        private final String m_timeFormat_Key = "TimeFormat";
        private final String m_dateFormat_Key = "DateFormat";

        FlatFileWizardPage() {
            super((LayoutManager)new BorderLayout());
            JPanel jPanel = new JPanel();
            this.m_delimiterOption = new JComboBox();
            int n = 0;
            while (n < this.delimiterStrings.length) {
                this.m_delimiterOption.addItem(this.delimiterStrings[n]);
                ++n;
            }
            this.m_delimiterOption.setSelectedIndex(LocalFlatFileDIM.this.m_prop.getInteger("LastDelim", 4));
            this.m_delimiterOption.addItemListener(new ItemListener(this){
                private final /* synthetic */ FlatFileWizardPage this$1;
                {
                    this.this$1 = flatFileWizardPage;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    FlatFileWizardPage.access$300(this.this$1);
                    this.this$1.doEnable();
                }
            });
            int n2 = LocalFlatFileDIM.this.m_prop.getInteger("LastCustDelimChar", 0);
            this.m_custDelimiter = n2 > 0 ? new JASTextField(String.valueOf((char)n2), 3) : new JASTextField(3);
            this.m_custDelimiter.addKeyListener((KeyListener)((Object)this));
            jPanel.add(this.m_delimiterOption);
            jPanel.add(this.m_customDelimiterLabel);
            jPanel.add((Component)this.m_custDelimiter);
            jPanel.setBorder(BorderFactory.createTitledBorder("Set column delimiter"));
            this.enableCustomDelimiter();
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(BorderFactory.createTitledBorder("Select string delimiter:"));
            this.m_stringDelim = new JComboBox();
            int n3 = 0;
            while (n3 < this.stringDelimiterStrings.length) {
                this.m_stringDelim.addItem(this.stringDelimiterStrings[n3]);
                ++n3;
            }
            this.m_stringDelim.setSelectedIndex(LocalFlatFileDIM.this.m_prop.getInteger("LastStringDelim", 2));
            jPanel2.add(this.m_stringDelim);
            this.m_filePanel = new OpenLocalFilePanel(true, true, "FlatFile");
            this.m_filePanel.addChangeListener((ChangeListener)this);
            JPanel jPanel3 = new JPanel(new FlowLayout(0));
            JCheckBox jCheckBox = new JCheckBox("Title in first line", LocalFlatFileDIM.this.m_firstLineHasTitle = LocalFlatFileDIM.this.m_prop.getBoolean("FirstLineHasTitle", false));
            jCheckBox.setMnemonic('T');
            JCheckBox jCheckBox2 = new JCheckBox(this.headerCheckBoxString() + "    ", LocalFlatFileDIM.this.m_hasHeaders = LocalFlatFileDIM.this.m_prop.getBoolean("HasHeaders", true));
            jCheckBox2.setMnemonic('h');
            ActionListener actionListener = new ActionListener(this, jCheckBox2){
                private final /* synthetic */ JCheckBox val$headers;
                private final /* synthetic */ FlatFileWizardPage this$1;
                {
                    this.this$1 = flatFileWizardPage;
                    this.val$headers = jCheckBox;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    if (jCheckBox == this.val$headers) {
                        LocalFlatFileDIM.access$200(FlatFileWizardPage.access$600(this.this$1)).setBoolean("HasHeaders", LocalFlatFileDIM.access$502(FlatFileWizardPage.access$600(this.this$1), jCheckBox.isSelected()));
                    } else {
                        LocalFlatFileDIM.access$200(FlatFileWizardPage.access$600(this.this$1)).setBoolean("FirstLineHasTitle", LocalFlatFileDIM.access$402(FlatFileWizardPage.access$600(this.this$1), jCheckBox.isSelected()));
                        this.val$headers.setText(FlatFileWizardPage.access$700(this.this$1));
                    }
                }
            };
            jCheckBox.addActionListener(actionListener);
            jCheckBox2.addActionListener(actionListener);
            jPanel3.add(jCheckBox);
            jPanel3.add(jCheckBox2);
            LocalFlatFileDIM.this.m_dateTimeFormat = LocalFlatFileDIM.this.m_prop.getString("DateTimeFormat", "dd-MMM-yyyy HH:mm:ss");
            LocalFlatFileDIM.this.m_timeFormat = LocalFlatFileDIM.this.m_prop.getString("TimeFormat", "HH:mm:ss");
            LocalFlatFileDIM.this.m_dateFormat = LocalFlatFileDIM.this.m_prop.getString("DateFormat", "dd-MMM-yyyy");
            JButton jButton = new JButton("Date/Time Formats...");
            jButton.setMnemonic('D');
            ActionListener actionListener2 = new ActionListener(this){
                private final /* synthetic */ FlatFileWizardPage this$1;
                {
                    this.this$1 = flatFileWizardPage;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = this.this$1;
                    while (!(object instanceof Frame)) {
                        object = ((Component)object).getParent();
                    }
                    DateTimeFormatDialog dateTimeFormatDialog = this.this$1.new DateTimeFormatDialog((Frame)object);
                    dateTimeFormatDialog.doModal();
                }
            };
            jButton.addActionListener(actionListener2);
            jPanel3.add(jButton);
            ((Container)((Object)this)).add("South", jPanel3);
            ((Container)((Object)this)).add("Center", jPanel);
            ((Container)((Object)this)).add("East", jPanel2);
            ((Container)((Object)this)).add("North", (Component)this.m_filePanel);
        }

        public String getHelpTopic() {
            return "builtInModules.flatFile";
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.doEnable();
        }

        public void doEnable() {
            super.doEnable();
        }

        protected boolean getFinishEnabled() {
            return this.m_filePanel.getText().length() > 0 && (this.delimiterChars[this.m_delimiterOption.getSelectedIndex()] != -1 || this.m_custDelimiter.getText().length() > 0);
        }

        private void enableCustomDelimiter() {
            boolean bl = this.delimiterChars[this.m_delimiterOption.getSelectedIndex()] == -1;
            this.m_customDelimiterLabel.setEnabled(bl);
            this.m_customDelimiterLabel.repaint();
            this.m_custDelimiter.setEnabled(bl);
            this.m_custDelimiter.repaint();
        }

        private String headerCheckBoxString() {
            return (LocalFlatFileDIM.this.m_firstLineHasTitle ? "Second" : "First") + " line contains column headers";
        }

        public void onFinish() {
            String string;
            int n = this.m_stringDelim.getSelectedIndex();
            LocalFlatFileDIM.this.m_prop.setInteger("LastStringDelim", n);
            LocalFlatFileDIM.this.m_stringDelimChar = this.stringDelimiterChars[n];
            int n2 = this.m_delimiterOption.getSelectedIndex();
            LocalFlatFileDIM.this.m_prop.setInteger("LastDelim", n2);
            LocalFlatFileDIM.this.m_delim = this.delimiterChars[n2];
            if (LocalFlatFileDIM.this.m_delim == -1) {
                string = this.m_custDelimiter.getText();
                if (string.length() == 0) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "You must enter a custom delimiter character.", "Error", 0);
                    return;
                }
                if (string.length() == 1) {
                    LocalFlatFileDIM.this.m_delim = string.charAt(0);
                    LocalFlatFileDIM.this.m_prop.setInteger("LastCustDelimChar", LocalFlatFileDIM.this.m_delim);
                } else {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Cannot enter more than one delimiting character", "Error", 0);
                    return;
                }
            }
            string = this.m_filePanel.getText();
            LocalFlatFileDIM.this.m_gzip = this.m_filePanel.getGZIPed();
            LocalFlatFileDIM.this.m_ljb.createJob(string);
            this.m_filePanel.saveState();
        }

        protected void dispose() {
            super.dispose();
        }

        protected void handleError(String string, Throwable throwable) {
            super.handleError(string, throwable);
        }

        static /* synthetic */ void access$300(FlatFileWizardPage flatFileWizardPage) {
            flatFileWizardPage.enableCustomDelimiter();
        }

        static /* synthetic */ String access$700(FlatFileWizardPage flatFileWizardPage) {
            return flatFileWizardPage.headerCheckBoxString();
        }

        private class DateTimeFormatDialog
        extends JASDialog {
            private JASTextField m_dateTimeField;
            private JASTextField m_timeField;
            private JASTextField m_dateField;

            DateTimeFormatDialog(Frame frame) {
                super(frame, "Date/Time Format");
                this.m_dateTimeField = new JASTextField(LocalFlatFileDIM.this.m_dateTimeFormat);
                this.m_timeField = new JASTextField(LocalFlatFileDIM.this.m_timeFormat);
                this.m_dateField = new JASTextField(LocalFlatFileDIM.this.m_dateFormat);
                Container container = this.getContentPane();
                container.setLayout((LayoutManager)new TableLayout());
                container.add("1 1", new JLabel("Date-Time Format"));
                container.add("2 1", (Component)this.m_dateTimeField);
                container.add("1 2", new JLabel("Time Format"));
                container.add("2 2", (Component)this.m_timeField);
                container.add("1 3", new JLabel("Date Format"));
                container.add("2 3", (Component)this.m_dateField);
                this.setHelpTopic("builtInModules.flatFile.dateTimeFormat");
                this.pack();
            }

            public void onOK() {
                super.onOK();
                LocalFlatFileDIM.this.m_dateTimeFormat = this.m_dateTimeField.getText();
                LocalFlatFileDIM.this.m_timeFormat = this.m_timeField.getText();
                LocalFlatFileDIM.this.m_dateFormat = this.m_dateField.getText();
                LocalFlatFileDIM.this.m_prop.setString("DateTimeFormat", LocalFlatFileDIM.this.m_dateTimeFormat);
                LocalFlatFileDIM.this.m_prop.setString("TimeFormat", LocalFlatFileDIM.this.m_timeFormat);
                LocalFlatFileDIM.this.m_prop.setString("DateFormat", LocalFlatFileDIM.this.m_dateFormat);
            }
        }
    }
}

