/*
 * Decompiled with CFR 0.152.
 */
package jasext.flatfileserver;

import jas.hist.Statistics;
import jasext.flatfileserver.DataColumn;
import jasext.flatfileserver.StringDataColumn;

class IntegerDataColumn
extends DataColumn {
    private int min = 0;
    private int max = 1;
    private int[] data;

    IntegerDataColumn(StringDataColumn stringDataColumn) {
        super(stringDataColumn);
        this.data = new int[stringDataColumn.getSize()];
        String string = null;
        if (this.data.length > 0) {
            string = stringDataColumn.getString(0);
            this.max = string == null ? 0 : Integer.valueOf(string);
            this.min = this.max;
        }
        int n = 0;
        while (n < this.data.length) {
            int n2;
            string = stringDataColumn.getString(n);
            int n3 = n2 = string == null ? 0 : Integer.parseInt(string);
            if (n2 > this.max) {
                this.max = n2;
            }
            if (n2 < this.min) {
                this.min = n2;
            }
            this.data[n] = n2;
            ++n;
        }
    }

    public int getSize() {
        return this.data.length;
    }

    public double[][] rebin(int n, double d, double d2, boolean bl, boolean bl2) {
        double[] dArray = new double[n];
        double d3 = (d2 - d) / (double)n;
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = 0.0;
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.data.length) {
            int n4 = (int)(((double)this.data[n3] - d) / d3);
            if (n4 >= 0 && n4 < n) {
                int n5 = n4;
                dArray[n5] = dArray[n5] + 1.0;
            }
            ++n3;
        }
        double[][] dArrayArray = new double[][]{dArray};
        return dArrayArray;
    }

    public String[] getAxisLabels() {
        return null;
    }

    public boolean isRebinnable() {
        return true;
    }

    public int getAxisType() {
        return 4;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public int getBins() {
        return 40;
    }

    double getDouble(int n) {
        return this.data[n];
    }

    int getInt(int n) {
        return this.data[n];
    }

    String getType() {
        return "integer";
    }

    public Statistics getStatistics() {
        return null;
    }
}

