/*
 * Decompiled with CFR 0.152.
 */
package jasext.flatfileserver;

import hep.analysis.AbstractNTupleEventData;
import hep.analysis.EndOfDataException;
import hep.analysis.EventData;
import hep.analysis.EventDataException;
import hep.analysis.NTupleEventData;
import jas.jds.module.AnnotatedEventSource;
import jas.jds.module.LocalJobBuilder;
import jas.util.ArbitraryNameGenerator;
import jas.util.FileReaderWithProgressBar;
import jas.util.tree.TreeItem;
import jasext.flatfileserver.AbsentFieldValue;
import jasext.flatfileserver.BadFieldValue;
import jasext.flatfileserver.DataColumn;
import jasext.flatfileserver.ExponentialFormat;
import jasext.flatfileserver.ExtraFieldValue;
import jasext.flatfileserver.FlatFileException;
import jasext.flatfileserver.FlatFileSyntaxException;
import jasext.flatfileserver.IntegerFormat;
import jasext.flatfileserver.NoDataFound;
import jasext.flatfileserver.StringDataColumn;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;

public class FlatFileEventSource
implements AnnotatedEventSource {
    public static final int NO_STRING_DELIMITER = -4;
    public static final int WHITESPACE_DELIMITED = -4;
    private DataColumn[] data;
    private int ith_event = 0;
    private NTupleEventData event = new FlatFileEventData();
    private Hashtable fieldNameHash = new Hashtable();
    private int fieldCount;
    private int rowCount;
    private int quoteChar = -4;
    private int delimChar = -4;
    private String m_name;
    private String m_nameOnTree;
    private boolean m_containsHeaders = true;
    private boolean m_firstLineContainsTitle = false;
    private boolean m_gzip = false;
    private BoundedRangeModel m_model = null;
    private LocalJobBuilder m_ljb = null;
    private String m_dateTimeFormat = "dd-MMM-yyyy hh:mm:ss";
    private String m_timeFormat = "hh:mm:ss";
    private String m_dateFormat = "dd-MMM-yyyy";
    private Format[] formats = new Format[]{new IntegerFormat(), new SimpleDateFormat(this.m_dateTimeFormat), new SimpleDateFormat(this.m_timeFormat), new SimpleDateFormat(this.m_dateFormat), new ExponentialFormat()};
    static /* synthetic */ Class class$hep$analysis$NTupleEventData;

    public FlatFileEventSource(String string) throws FlatFileException {
        this.m_name = string;
        this.init();
    }

    public FlatFileEventSource() {
    }

    public Class getEventDataClass() {
        return class$hep$analysis$NTupleEventData == null ? (class$hep$analysis$NTupleEventData = FlatFileEventSource.class$("hep.analysis.NTupleEventData")) : class$hep$analysis$NTupleEventData;
    }

    public void close() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws FlatFileException {
        try {
            if (this.m_ljb != null) {
                this.m_ljb.setMessage("Opening file " + this.m_name);
            }
            BufferedReader bufferedReader = this.m_gzip ? (this.m_model == null ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.m_name)))) : new BufferedReader(new InputStreamReader(new GZIPInputStream((InputStream)new FileReaderWithProgressBar(this.m_name, this.m_model))))) : (this.m_model == null ? new BufferedReader(new FileReader(this.m_name)) : new BufferedReader(new InputStreamReader((InputStream)new FileReaderWithProgressBar(this.m_name, this.m_model))));
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.resetSyntax();
            streamTokenizer.eolIsSignificant(true);
            try {
                try {
                    this.retrieveData(streamTokenizer);
                }
                catch (FlatFileSyntaxException flatFileSyntaxException) {
                    throw new FlatFileException("Error reading " + this.m_name + " at line " + streamTokenizer.lineno(), flatFileSyntaxException);
                }
                catch (Throwable throwable) {
                    throw new FlatFileException("Error while reading: " + this.m_name, throwable);
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            bufferedReader.close();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FlatFileException("Cannot open: " + this.m_name, fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new FlatFileException("Cannot open: " + this.m_name, iOException);
        }
    }

    private void retrieveData(StreamTokenizer streamTokenizer) throws IOException, FlatFileSyntaxException {
        Vector<String> vector;
        this.fieldCount = 0;
        if (this.m_firstLineContainsTitle) {
            streamTokenizer.wordChars(0, 65535);
            streamTokenizer.whitespaceChars(10, 13);
            streamTokenizer.nextToken();
            this.m_nameOnTree = streamTokenizer.sval;
            streamTokenizer.nextToken();
        } else {
            this.m_nameOnTree = this.format(this.m_name);
        }
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.wordChars(33, 255);
        if (this.quoteChar != -4) {
            streamTokenizer.quoteChar(this.quoteChar);
        }
        if (this.delimChar != -4) {
            streamTokenizer.ordinaryChar(this.delimChar);
            streamTokenizer.wordChars(32, 32);
        }
        if (this.m_containsHeaders) {
            this.rowCount = 0;
            vector = new Vector<String>();
            streamTokenizer.nextToken();
            while (streamTokenizer.ttype != -1 && streamTokenizer.ttype != 10) {
                if (this.fieldCount != 0 && streamTokenizer.ttype == this.delimChar) {
                    streamTokenizer.nextToken();
                }
                if (streamTokenizer.ttype == this.delimChar || streamTokenizer.ttype == 10) {
                    vector.addElement("");
                    ++this.fieldCount;
                    continue;
                }
                if (streamTokenizer.ttype != -3 && streamTokenizer.ttype != this.quoteChar) {
                    throw new BadFieldValue();
                }
                vector.addElement(streamTokenizer.sval.trim());
                ++this.fieldCount;
                streamTokenizer.nextToken();
            }
            this.data = new DataColumn[this.fieldCount];
            int n = 0;
            while (n < this.fieldCount) {
                this.data[n] = new StringDataColumn((String)vector.elementAt(n));
                this.fieldNameHash.put(vector.elementAt(n), new Integer(n));
                ++n;
            }
        } else {
            this.rowCount = 1;
            vector = new Vector();
            streamTokenizer.nextToken();
            while (streamTokenizer.ttype != 10 && streamTokenizer.ttype != -1) {
                if (this.fieldCount != 0 && streamTokenizer.ttype == this.delimChar) {
                    streamTokenizer.nextToken();
                }
                if (streamTokenizer.ttype == this.delimChar || streamTokenizer.ttype == 10) {
                    vector.addElement(null);
                } else {
                    if (streamTokenizer.ttype != -3 && streamTokenizer.ttype != this.quoteChar) {
                        throw new BadFieldValue();
                    }
                    vector.addElement(streamTokenizer.sval.trim());
                    streamTokenizer.nextToken();
                }
                ++this.fieldCount;
            }
            this.data = new DataColumn[this.fieldCount];
            String[] stringArray = new String[this.fieldCount];
            new ArbitraryNameGenerator().fillArray(stringArray);
            int n = 0;
            while (n < this.fieldCount) {
                this.data[n] = new StringDataColumn(stringArray[n]);
                ((StringDataColumn)this.data[n]).addRow((String)vector.elementAt(n));
                this.fieldNameHash.put(stringArray[n], new Integer(n));
                ++n;
            }
        }
        if (streamTokenizer.ttype == -1) {
            throw new NoDataFound();
        }
        if (this.m_ljb != null) {
            this.m_ljb.setMessage("Reading file " + this.m_name);
        }
        while (streamTokenizer.ttype != -1) {
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == -1) break;
            if (streamTokenizer.ttype == 10) continue;
            this.readDataRow(streamTokenizer);
            ++this.rowCount;
        }
        if (this.m_ljb != null) {
            this.m_ljb.setMessage("Converting " + this.m_name);
            this.m_model.setRangeProperties(0, 0, 0, this.fieldCount - 1, false);
        }
        int n = 0;
        while (n < this.fieldCount) {
            this.data[n] = ((StringDataColumn)this.data[n]).convert(this.formats);
            if (this.m_model != null) {
                this.m_model.setValue(n);
            }
            ++n;
        }
        if (this.m_ljb != null) {
            this.m_ljb.setMessage("Processing complete: file " + this.m_name);
        }
    }

    private void readDataRow(StreamTokenizer streamTokenizer) throws IOException, BadFieldValue, AbsentFieldValue, ExtraFieldValue {
        int n = 0;
        while (streamTokenizer.ttype != 10 && streamTokenizer.ttype != -1) {
            if (n != 0 && streamTokenizer.ttype == this.delimChar) {
                streamTokenizer.nextToken();
            }
            if (streamTokenizer.ttype == this.delimChar || streamTokenizer.ttype == 10) {
                if (n >= this.fieldCount) {
                    throw new ExtraFieldValue();
                }
                ((StringDataColumn)this.data[n]).addRow(null);
                ++n;
                continue;
            }
            if (streamTokenizer.ttype != -3 && streamTokenizer.ttype != this.quoteChar) {
                throw new BadFieldValue();
            }
            if (n >= this.fieldCount) {
                throw new ExtraFieldValue();
            }
            ((StringDataColumn)this.data[n]).addRow(streamTokenizer.sval.trim());
            ++n;
            streamTokenizer.nextToken();
        }
        if (n < this.fieldCount) {
            throw new AbsentFieldValue();
        }
    }

    public String getDateTimeFormat() {
        return this.m_dateTimeFormat;
    }

    public void setDateTimeFormat(String string) {
        this.m_dateTimeFormat = string;
        this.formats[1] = new SimpleDateFormat(string);
    }

    public String getTimeFormat() {
        return this.m_timeFormat;
    }

    public void setTimeFormat(String string) {
        this.m_timeFormat = string;
        this.formats[2] = new SimpleDateFormat(string);
    }

    public String getDateFormat() {
        return this.m_dateFormat;
    }

    public void setDateFormat(String string) {
        this.m_dateFormat = string;
        this.formats[3] = new SimpleDateFormat(string);
    }

    public int getDelim() {
        return this.delimChar;
    }

    public void setDelim(int n) {
        this.delimChar = n;
    }

    public int getQuoteChar() {
        return this.quoteChar;
    }

    public void setQuoteChar(int n) {
        this.quoteChar = n;
    }

    public String getFileName() {
        return this.m_name;
    }

    public void setFileName(String string) {
        this.m_name = string;
    }

    public boolean getHasHeaders() {
        return this.m_containsHeaders;
    }

    public void setHasHeaders(boolean bl) {
        this.m_containsHeaders = bl;
    }

    public boolean getFirstLineHasTitle() {
        return this.m_firstLineContainsTitle;
    }

    public void setFirstLineHasTitle(boolean bl) {
        this.m_firstLineContainsTitle = bl;
    }

    public boolean getGZIP() {
        return this.m_gzip;
    }

    public void setGZIP(boolean bl) {
        this.m_gzip = bl;
    }

    void setLocalJobBuilder(LocalJobBuilder localJobBuilder) {
        this.m_ljb = localJobBuilder;
        if (this.m_ljb != null) {
            this.m_model = new DefaultBoundedRangeModel();
            this.m_ljb.setProgressModel(this.m_model);
        }
    }

    private String format(String string) {
        try {
            String string2 = File.separator;
            int n = string.lastIndexOf(string2);
            n = n >= 0 ? (n += string2.length()) : 0;
            int n2 = string.lastIndexOf(46);
            if (n2 > n) {
                return string.substring(n, n2);
            }
            return string.substring(n);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public TreeItem[] getItems() {
        TreeItem[] treeItemArray = new TreeItem[this.fieldCount];
        int n = 0;
        while (n < this.fieldCount) {
            treeItemArray[n] = new TreeItem();
            treeItemArray[n].path = new String[1];
            treeItemArray[n].path[0] = this.data[n].getTitle();
            treeItemArray[n].type = this.data[n].getType();
            ++n;
        }
        return treeItemArray;
    }

    public Object getItem(TreeItem treeItem) {
        int n = (Integer)this.fieldNameHash.get(treeItem.path[treeItem.path.length - 1]);
        return this.data[n];
    }

    public int getTotalNumberOfEvents() {
        return this.rowCount;
    }

    public void beforeFirstEvent() {
        this.ith_event = -1;
    }

    public void afterLastEvent() {
    }

    public EventData getNextEvent() throws EndOfDataException {
        if (++this.ith_event >= this.rowCount) {
            throw new EndOfDataException();
        }
        return this.event;
    }

    public String getName() {
        return this.m_nameOnTree;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class FlatFileEventData
    extends AbstractNTupleEventData {
        private FlatFileEventData() {
        }

        public double getDouble(String string) {
            Integer n = (Integer)FlatFileEventSource.this.fieldNameHash.get(string);
            if (n == null) {
                throw new EventDataException("Can not find column " + string);
            }
            return FlatFileEventSource.this.data[n].getDouble(FlatFileEventSource.this.ith_event);
        }

        public int getInt(String string) {
            Integer n = (Integer)FlatFileEventSource.this.fieldNameHash.get(string);
            if (n == null) {
                throw new EventDataException("Can not find column " + string);
            }
            return FlatFileEventSource.this.data[n].getInt(FlatFileEventSource.this.ith_event);
        }

        public Date getDate(String string) {
            Integer n = (Integer)FlatFileEventSource.this.fieldNameHash.get(string);
            if (n == null) {
                throw new EventDataException("Can not find column " + string);
            }
            return FlatFileEventSource.this.data[n].getDate(FlatFileEventSource.this.ith_event);
        }

        public String getString(String string) {
            Integer n = (Integer)FlatFileEventSource.this.fieldNameHash.get(string);
            if (n == null) {
                throw new EventDataException("Can not find column " + string);
            }
            return FlatFileEventSource.this.data[n].getString(FlatFileEventSource.this.ith_event);
        }

        public double getDouble(int n) {
            return FlatFileEventSource.this.data[n].getDouble(FlatFileEventSource.this.ith_event);
        }

        public int getInt(int n) {
            return FlatFileEventSource.this.data[n].getInt(FlatFileEventSource.this.ith_event);
        }

        public Date getDate(int n) {
            return FlatFileEventSource.this.data[n].getDate(FlatFileEventSource.this.ith_event);
        }

        public String getString(int n) {
            return FlatFileEventSource.this.data[n].getString(FlatFileEventSource.this.ith_event);
        }

        public int findColumn(String string) {
            Integer n = (Integer)FlatFileEventSource.this.fieldNameHash.get(string);
            if (n == null) {
                throw new EventDataException("Can not find column " + string);
            }
            return n;
        }
    }
}

