/*
 * Decompiled with CFR 0.152.
 */
package jasext.flatfileserver;

import jas.hist.Statistics;
import jasext.flatfileserver.DataColumn;
import jasext.flatfileserver.StringDataColumn;

class DoubleDataColumn
extends DataColumn {
    private double min = 0.0;
    private double max = 1.0;
    private double[] data;

    DoubleDataColumn(StringDataColumn stringDataColumn) {
        super(stringDataColumn);
        this.data = new double[stringDataColumn.getSize()];
        if (this.data.length > 0) {
            String string = stringDataColumn.getString(0);
            this.max = string == null ? 0.0 : Double.valueOf(string);
            this.min = this.max;
        }
        int n = 0;
        while (n < this.data.length) {
            double d;
            String string = stringDataColumn.getString(n);
            double d2 = d = string == null ? 0.0 : Double.valueOf(string);
            if (d > this.max) {
                this.max = d;
            }
            if (d < this.min) {
                this.min = d;
            }
            this.data[n] = d;
            ++n;
        }
    }

    public int getSize() {
        return this.data.length;
    }

    public double[][] rebin(int n, double d, double d2, boolean bl, boolean bl2) {
        double[] dArray = new double[n];
        double d3 = (d2 - d) / (double)n;
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = 0.0;
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.data.length) {
            double d4 = this.data[n3];
            if (d4 >= d && d4 < d2) {
                int n4 = (int)((d4 - d) / d3);
                dArray[n4] = dArray[n4] + 1.0;
            }
            ++n3;
        }
        double[][] dArrayArray = new double[][]{dArray};
        return dArrayArray;
    }

    public String[] getAxisLabels() {
        return null;
    }

    public boolean isRebinnable() {
        return true;
    }

    public int getAxisType() {
        return 1;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public int getBins() {
        return 40;
    }

    double getDouble(int n) {
        return this.data[n];
    }

    String getType() {
        return "float";
    }

    public Statistics getStatistics() {
        return null;
    }
}

