/*
 * Decompiled with CFR 0.152.
 */
package jasext.flatfileserver;

import jas.hist.Statistics;
import jasext.flatfileserver.DataColumn;
import jasext.flatfileserver.StringDataColumn;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

class DateDataColumn
extends DataColumn {
    private Date min = null;
    private Date max = null;
    private Date[] data;

    DateDataColumn(StringDataColumn stringDataColumn, DateFormat dateFormat) {
        super(stringDataColumn);
        this.data = new Date[stringDataColumn.getSize()];
        try {
            int n = 0;
            while (n < this.data.length) {
                String string = stringDataColumn.getString(n);
                if (string == null) {
                    this.data[n] = null;
                } else {
                    Date date = dateFormat.parse(string);
                    if (this.min == null) {
                        this.min = this.max = date;
                    } else {
                        if (date.after(this.max)) {
                            this.max = date;
                        }
                        if (date.before(this.min)) {
                            this.min = date;
                        }
                    }
                    this.data[n] = date;
                }
                ++n;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public int getSize() {
        return this.data.length;
    }

    public double[][] rebin(int n, double d, double d2, boolean bl, boolean bl2) {
        double[] dArray = new double[n];
        double d3 = this.getMin();
        double d4 = (this.getMax() - d3) / (double)n;
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = 0.0;
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.data.length) {
            int n4;
            if (this.data[n3] != null && (n4 = (int)(((double)this.data[n3].getTime() / 1000.0 - d3) / d4)) >= 0 && n4 < n) {
                int n5 = n4;
                dArray[n5] = dArray[n5] + 1.0;
            }
            ++n3;
        }
        double[][] dArrayArray = new double[][]{dArray};
        return dArrayArray;
    }

    public String[] getAxisLabels() {
        return null;
    }

    public boolean isRebinnable() {
        return true;
    }

    public int getAxisType() {
        return 3;
    }

    public double getMin() {
        return (double)this.min.getTime() / 1000.0;
    }

    public double getMax() {
        return (double)this.max.getTime() / 1000.0;
    }

    public int getBins() {
        return 40;
    }

    Date getDate(int n) {
        return this.data[n];
    }

    String getType() {
        return "time";
    }

    public Statistics getStatistics() {
        return null;
    }
}

