/*
 * Decompiled with CFR 0.152.
 */
package jasext.jdbc.access;

import jas.util.FileTypeFileFilter;
import jas.util.JASWizardPage;
import jas.util.UserProperties;
import jasext.jdbc.SimplePage;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class JDBCAccessPage
extends SimplePage
implements ActionListener {
    private JTextField filename;

    public JDBCAccessPage() {
        ((Container)((Object)this)).add(new JLabel("MS Access Database"), this.labelC);
        this.filename = new JTextField(this.getDefaultSize());
        UserProperties userProperties = UserProperties.getUserProperties();
        String string = userProperties.getProperty("jasext.jdbc." + this.getJDBCName() + ".file", "");
        this.filename.setText(string);
        this.filename.addKeyListener((KeyListener)((Object)this));
        GridBagConstraints gridBagConstraints = (GridBagConstraints)this.fieldC.clone();
        gridBagConstraints.gridwidth = 1;
        ((Container)((Object)this)).add(this.filename, gridBagConstraints);
        JButton jButton = new JButton("Browse...");
        jButton.addActionListener(this);
        ((Container)((Object)this)).add(jButton, this.fieldC);
    }

    public JASWizardPage getNext() {
        JASWizardPage jASWizardPage = super.getNext();
        UserProperties userProperties = UserProperties.getUserProperties();
        userProperties.setProperty("jasext.jdbc." + this.getJDBCName() + ".file", this.filename.getText());
        return jASWizardPage;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.filename.getText();
        JFileChooser jFileChooser = !string.equals("") ? new JFileChooser(string) : new JFileChooser();
        jFileChooser.setDialogTitle("Open Database ...");
        jFileChooser.setFileFilter((FileFilter)new FileTypeFileFilter("mdb", "MS Access Database *(*.mdb)"));
        if (jFileChooser.showOpenDialog((Component)((Object)this)) == 0) {
            this.filename.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            this.doEnable();
        }
    }

    protected boolean getNextEnabled() {
        return !this.filename.getText().equals("");
    }

    protected String getDriver() {
        return "sun.jdbc.odbc.JdbcOdbcDriver";
    }

    protected String getURL() {
        return "jdbc:odbc:DRIVER={Microsoft Access Driver (*.mdb)};DBQ=" + this.filename.getText();
    }

    protected String getUserID() {
        return "";
    }

    protected String getPassword() {
        return "";
    }

    protected String getJDBCName() {
        return "MS Access Database";
    }
}

