/*
 * Decompiled with CFR 0.152.
 */
package jasext.jdbc;

import jas.util.Finishable;
import jas.util.HasNextPages;
import jas.util.JASWizardPage;
import jasext.jdbc.JDBCLocalDIM;
import jasext.jdbc.TableListPage;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.SQLException;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

class SQLPage
extends JASWizardPage
implements HasNextPages,
Finishable,
ActionListener,
Runnable {
    private JDBCLocalDIM dim;
    private TableListPage next = new TableListPage();
    private JRadioButton list = new JRadioButton("Choose from a list of Tables and Views");
    private JRadioButton sql;
    private JTextField sqltext;

    SQLPage() {
        super((LayoutManager)new GridBagLayout());
        this.list.addActionListener(this);
        this.list.setSelected(true);
        this.sql = new JRadioButton("SQL Query:");
        this.sql.addActionListener(this);
        this.sqltext = new JTextField(40);
        this.sqltext.addKeyListener((KeyListener)((Object)this));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.list);
        buttonGroup.add(this.sql);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        ((Container)((Object)this)).add(this.list, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ((Container)((Object)this)).add(this.sql, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        ((Container)((Object)this)).add(this.sqltext, gridBagConstraints);
    }

    public boolean getFinishEnabled() {
        return this.sql.isSelected() && !this.sqltext.getText().equals("");
    }

    public boolean getNextEnabled() {
        return this.list.isSelected();
    }

    public JASWizardPage getNext() {
        try {
            this.doBusy(this);
            return this.next;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public JASWizardPage[] getNextWizardPages() {
        return new JASWizardPage[]{this.next};
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.sql.setSelected(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.doEnable();
    }

    public void run() {
        try {
            this.next.setContext(this.dim);
        }
        catch (SQLException sQLException) {
            this.handleError("Could not create table list", sQLException);
            throw new RuntimeException();
        }
    }

    public void onFinish() {
        this.dim.createJob(this.sqltext.getText());
    }

    void setContext(JDBCLocalDIM jDBCLocalDIM) {
        this.dim = jDBCLocalDIM;
    }
}

