/*
 * Decompiled with CFR 0.152.
 */
package jasext.jdbc;

import hep.analysis.EventSource;
import jas.jds.module.AbstractDIM;
import jas.jds.module.DIM;
import jas.jds.module.ModuleException;
import jas.jds.module.ServerRegistry;
import jas.util.NestedRuntimeException;
import jasext.jdbc.JDBCEventSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class JDBCServer
implements DIM {
    private Connection conn;
    private String SQL;
    private String name;
    private Class driver;

    public static void main(String[] stringArray) throws Exception {
        JDBCServer jDBCServer = new JDBCServer(stringArray);
        ServerRegistry.registerServer((AbstractDIM)jDBCServer);
    }

    public JDBCServer(String[] stringArray) throws Exception {
        if (stringArray.length != 4) {
            throw new RuntimeException("JDBCServer requires 2 arguments");
        }
        this.name = stringArray[0];
        this.driver = Class.forName(stringArray[1]);
        this.conn = DriverManager.getConnection(stringArray[2]);
        this.SQL = stringArray[3];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EventSource openDataSet(String string) throws ModuleException {
        try {
            JDBCEventSource jDBCEventSource;
            Statement statement = this.conn.createStatement();
            try {
                String string2;
                ResultSet resultSet = statement.executeQuery(this.SQL);
                do {
                    if (resultSet.next()) continue;
                    throw new ModuleException("Dataset " + string + " not found.", null);
                } while (!(string2 = resultSet.getString("name")).equals(string));
                String string3 = resultSet.getString("sql");
                jDBCEventSource = new JDBCEventSource(string2, this.conn, string3);
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                statement.close();
                throw throwable;
            }
            statement.close();
            return jDBCEventSource;
        }
        catch (SQLException sQLException) {
            throw new ModuleException("Exception while opening " + string, (Throwable)sQLException);
        }
    }

    public Vector getDataSets() {
        Vector<String> vector = new Vector<String>();
        try {
            Statement statement = this.conn.createStatement();
            try {
                ResultSet resultSet = statement.executeQuery(this.SQL);
                while (resultSet.next()) {
                    String string = resultSet.getString("name");
                    vector.addElement(string);
                }
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                statement.close();
                throw throwable;
            }
            statement.close();
            {
            }
        }
        catch (SQLException sQLException) {
            throw new NestedRuntimeException("Error getting dataset list", (Throwable)sQLException);
        }
        return vector;
    }

    public String toString() {
        return this.name;
    }
}

