/*
 * Decompiled with CFR 0.152.
 */
package jasext.jdbc;

import jas.util.HasNextPages;
import jas.util.JASWizardPage;
import jasext.jdbc.JDBCLocalDIM;
import jasext.jdbc.SQLPage;
import java.awt.LayoutManager;
import java.sql.SQLException;

abstract class JDBCPage
extends JASWizardPage
implements HasNextPages {
    private SQLPage next = new SQLPage();
    private JDBCLocalDIM dim;

    JDBCPage(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public JASWizardPage getNext() {
        try {
            this.dim.setDriver(this.getDriver());
            this.dim.setURL(this.getURL());
            this.dim.setUserID(this.getUserID());
            this.dim.setPassword(this.getPassword());
            this.dim.openConnection();
            this.next.setContext(this.dim);
            return this.next;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.handleError("Could not load driver " + this.getDriver(), classNotFoundException);
            return null;
        }
        catch (SQLException sQLException) {
            this.handleError("Cannot open database connection", sQLException);
            return null;
        }
    }

    public JASWizardPage[] getNextWizardPages() {
        return new JASWizardPage[]{this.next};
    }

    void setDIM(JDBCLocalDIM jDBCLocalDIM) {
        this.dim = jDBCLocalDIM;
    }

    protected abstract String getDriver();

    protected abstract String getURL();

    protected abstract String getUserID();

    protected abstract String getPassword();

    protected abstract String getJDBCName();
}

