/*
 * Decompiled with CFR 0.152.
 */
package jasext.jdbc;

import hep.analysis.EventSource;
import jas.jds.module.LocalDIM;
import jas.jds.module.LocalJobBuilder;
import jas.jds.module.ModuleException;
import jas.util.HasNextPages;
import jas.util.JASWizardPage;
import jas.util.NestedRuntimeException;
import jas.util.UserProperties;
import jasext.jdbc.JDBCEventSource;
import jasext.jdbc.JDBCODBCPage;
import jasext.jdbc.JDBCOtherPage;
import jasext.jdbc.JDBCPage;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;

public class JDBCLocalDIM
implements LocalDIM {
    private Connection conn;
    private DefaultComboBoxModel model = new DefaultComboBoxModel(pages);
    private LocalJobBuilder m_ljb;
    private JDBCWizardPage wizard;
    private String sql;
    private String fileName;
    private String driver;
    private String url;
    private String userID;
    private String password;
    private static int n = 0;
    private static Vector pages = new Vector();

    public JDBCLocalDIM() {
        UserProperties userProperties = UserProperties.getUserProperties();
        String string = userProperties.getProperty("jasext.jdbc.selected");
        if (string != null) {
            Enumeration enumeration = pages.elements();
            while (enumeration.hasMoreElements()) {
                JDBCPage jDBCPage = (JDBCPage)((Object)enumeration.nextElement());
                if (!jDBCPage.getJDBCName().equals(string)) continue;
                this.model.setSelectedItem((Object)jDBCPage);
            }
        }
        this.wizard = new JDBCWizardPage();
    }

    public static void register(JDBCPage jDBCPage) {
        pages.addElement(jDBCPage);
    }

    public void setLocalJobBuilder(LocalJobBuilder localJobBuilder) {
        this.m_ljb = localJobBuilder;
    }

    public void openConnection() throws SQLException, ClassNotFoundException {
        if (this.conn != null) {
            this.conn.close();
        }
        Class<?> clazz = Class.forName(this.driver);
        this.conn = DriverManager.getConnection(this.url, this.userID, this.password);
        try {
            this.conn.setReadOnly(true);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public JASWizardPage getSetupPage() {
        return this.wizard;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public String toString() {
        return "SQL Data Base";
    }

    public EventSource openDataSet(String string) throws ModuleException {
        try {
            JDBCEventSource jDBCEventSource = this.createEventSource(this.fileName, string);
            this.wizard.close();
            return jDBCEventSource;
        }
        catch (SQLException sQLException) {
            throw new ModuleException("SQL Exception opening dataset", (Throwable)sQLException);
        }
    }

    public JDBCEventSource createEventSource(String string, String string2) throws SQLException {
        if (string == null) {
            string = "SQL Dataset " + ++n;
        }
        JDBCEventSource jDBCEventSource = new JDBCEventSource(string, this.conn, string2);
        this.fileName = string;
        this.sql = string2;
        this.conn = null;
        return jDBCEventSource;
    }

    void createJob(String string) {
        try {
            this.m_ljb.createJob(string);
        }
        catch (Exception exception) {
            throw new NestedRuntimeException("Cannot create job", (Throwable)exception);
        }
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String string) {
        this.userID = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getSQL() {
        return this.sql;
    }

    static {
        JDBCLocalDIM.register(new JDBCODBCPage());
        JDBCLocalDIM.register(new JDBCOtherPage());
    }

    private static class JDBCListCellRenderer
    extends DefaultListCellRenderer {
        private JDBCListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.setText(((JDBCPage)((Object)object)).getJDBCName());
            return component;
        }
    }

    private class JDBCWizardPage
    extends JASWizardPage
    implements HasNextPages {
        private JComboBox choice;

        JDBCWizardPage() {
            super((LayoutManager)new FlowLayout());
            this.choice = new JComboBox(JDBCLocalDIM.this.model);
            this.choice.setEditable(false);
            this.choice.setRenderer(new JDBCListCellRenderer());
            ((Container)((Object)this)).add(new JLabel("Select type of database: "));
            ((Container)((Object)this)).add(this.choice);
        }

        public JASWizardPage getNext() {
            JDBCPage jDBCPage = (JDBCPage)((Object)JDBCLocalDIM.this.model.getSelectedItem());
            jDBCPage.setDIM(JDBCLocalDIM.this);
            UserProperties userProperties = UserProperties.getUserProperties();
            userProperties.setProperty("jasext.jdbc.selected", jDBCPage.getJDBCName());
            return jDBCPage;
        }

        public JASWizardPage[] getNextWizardPages() {
            JASWizardPage[] jASWizardPageArray = new JASWizardPage[JDBCLocalDIM.this.model.getSize()];
            int n = 0;
            while (n < jASWizardPageArray.length) {
                jASWizardPageArray[n] = (JASWizardPage)JDBCLocalDIM.this.model.getElementAt(n);
                ++n;
            }
            return jASWizardPageArray;
        }

        public void onCancel() {
            try {
                if (JDBCLocalDIM.this.conn != null) {
                    JDBCLocalDIM.this.conn.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        void close() {
            this.dispose();
        }
    }
}

