/*
 * Decompiled with CFR 0.152.
 */
package jasext.jdbc;

import hep.analysis.EndOfDataException;
import hep.analysis.EventData;
import hep.analysis.Partition;
import hep.analysis.partition.SimpleDatePartition;
import hep.analysis.partition.SimpleIntPartition;
import hep.analysis.partition.SimplePartition;
import hep.analysis.partition.StringPartition;
import jas.hep.PartitionAdapter;
import jas.jds.module.AnnotatedEventSource;
import jas.util.NestedRuntimeException;
import jas.util.tree.TreeItem;
import jasext.jdbc.JDBCEvent;
import jasext.jdbc.JDBCTypeMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;

public class JDBCEventSource
implements AnnotatedEventSource {
    private int m_nEvents = -1;
    private TreeItem[] m_items;
    private JDBCEvent m_events;
    private Connection m_conn;
    private PreparedStatement m_stmt;
    private String m_dataSourceName;
    private String m_SQL;
    static /* synthetic */ Class class$hep$analysis$NTupleEventData;

    JDBCEventSource(String string, Connection connection, String string2) throws SQLException {
        this.m_conn = connection;
        this.m_stmt = connection.prepareStatement(string2);
        this.m_events = new JDBCEvent(this.m_stmt);
        this.m_dataSourceName = string;
        this.m_SQL = string2;
        ResultSet resultSet = this.m_stmt.executeQuery();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        this.m_items = new TreeItem[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 + 1;
            this.m_items[n2] = new TreeItem();
            this.m_items[n2].path = new String[1];
            this.m_items[n2].path[0] = resultSetMetaData.getColumnName(n3);
            this.m_items[n2].type = JDBCTypeMap.findTypeMap(resultSetMetaData.getColumnType(n3)).getIcon();
            ++n2;
        }
        resultSet.close();
    }

    public String getName() {
        return this.m_dataSourceName;
    }

    public Class getEventDataClass() {
        return class$hep$analysis$NTupleEventData == null ? (class$hep$analysis$NTupleEventData = JDBCEventSource.class$("hep.analysis.NTupleEventData")) : class$hep$analysis$NTupleEventData;
    }

    public void close() {
        try {
            if (this.m_conn != null) {
                this.m_conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.m_conn = null;
        this.m_stmt = null;
    }

    public TreeItem[] getItems() {
        return this.m_items;
    }

    public Object getItem(TreeItem treeItem) {
        try {
            Statement statement = this.m_conn.createStatement();
            ResultSet resultSet = statement.executeQuery(this.m_SQL);
            int n = resultSet.findColumn(treeItem.path[treeItem.path.length - 1]);
            SimplePartition simplePartition = null;
            if (treeItem.type.equals("float")) {
                simplePartition = new SimplePartition();
                while (resultSet.next()) {
                    simplePartition.fill((double)resultSet.getFloat(n));
                }
            } else if (treeItem.type.equals("integer")) {
                simplePartition = new SimpleIntPartition();
                while (resultSet.next()) {
                    simplePartition.fill(resultSet.getInt(n));
                }
            } else if (treeItem.type.equals("time")) {
                simplePartition = new SimpleDatePartition();
                while (resultSet.next()) {
                    Timestamp timestamp = resultSet.getTimestamp(n);
                    if (timestamp == null) continue;
                    simplePartition.fill((Date)timestamp);
                }
            } else if (treeItem.type.equals("string")) {
                simplePartition = new StringPartition();
                while (resultSet.next()) {
                    String string = resultSet.getString(n);
                    simplePartition.fill(string == null ? "NULL" : string);
                }
            }
            resultSet.close();
            statement.close();
            if (simplePartition == null) {
                return null;
            }
            return PartitionAdapter.create((Partition)simplePartition, (String)treeItem.path[0]);
        }
        catch (SQLException sQLException) {
            throw new NestedRuntimeException("SQL Error", (Throwable)sQLException);
        }
    }

    public int getTotalNumberOfEvents() {
        return this.m_nEvents;
    }

    public EventData getNextEvent() throws EndOfDataException {
        this.m_events.nextEvent();
        return this.m_events;
    }

    public void beforeFirstEvent() {
        this.m_events.beforeFirstEvent();
    }

    public void afterLastEvent() {
        this.m_events.afterLastEvent();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

