/*
 * Decompiled with CFR 0.152.
 */
package jasext.jdbc;

import hep.analysis.AbstractNTupleEventData;
import hep.analysis.EndOfDataException;
import hep.analysis.EventData;
import hep.analysis.EventDataException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

final class JDBCEvent
extends AbstractNTupleEventData {
    private ResultSet m_rset;
    private PreparedStatement m_stmt;

    JDBCEvent(PreparedStatement preparedStatement) {
        this.m_stmt = preparedStatement;
        this.m_rset = null;
    }

    EventData nextEvent() throws EndOfDataException {
        try {
            if (!this.m_rset.next()) {
                throw new EndOfDataException();
            }
            return this;
        }
        catch (SQLException sQLException) {
            throw new EventDataException("Unexpected SQL problem " + sQLException);
        }
    }

    void beforeFirstEvent() {
        try {
            if (this.m_rset != null) {
                this.m_rset.close();
            }
            this.m_rset = this.m_stmt.executeQuery();
        }
        catch (SQLException sQLException) {
            throw new EventDataException("Unexpected SQL problem " + sQLException);
        }
    }

    void afterLastEvent() {
        try {
            this.m_rset.close();
            this.m_rset = null;
        }
        catch (SQLException sQLException) {
            throw new EventDataException("Unexpected SQL problem" + sQLException);
        }
    }

    public double getDouble(String string) {
        try {
            return this.m_rset.getDouble(string);
        }
        catch (SQLException sQLException) {
            throw new EventDataException("Error accessing column " + string + " " + sQLException);
        }
    }

    public int getInt(String string) {
        try {
            return this.m_rset.getInt(string);
        }
        catch (SQLException sQLException) {
            throw new EventDataException("Error accessing column " + string + " " + sQLException);
        }
    }

    public Date getDate(String string) {
        try {
            return this.m_rset.getTimestamp(string);
        }
        catch (SQLException sQLException) {
            throw new EventDataException("Error accessing column " + string + " " + sQLException);
        }
    }

    public String getString(String string) {
        try {
            return this.m_rset.getString(string);
        }
        catch (SQLException sQLException) {
            throw new EventDataException("Error accessing column " + string + " " + sQLException);
        }
    }

    public boolean getBoolean(String string) {
        try {
            return this.m_rset.getBoolean(string);
        }
        catch (SQLException sQLException) {
            throw new EventDataException("Error accessing column " + string + " " + sQLException);
        }
    }

    public Object getObject(String string) {
        try {
            return this.m_rset.getObject(string);
        }
        catch (SQLException sQLException) {
            throw new EventDataException("Error accessing column " + string + " " + sQLException);
        }
    }

    public double getDouble(int n) {
        try {
            return this.m_rset.getDouble(n + 1);
        }
        catch (SQLException sQLException) {
            throw new EventDataException("Error accessing column " + n + " " + sQLException);
        }
    }

    public int getInt(int n) {
        try {
            return this.m_rset.getInt(n + 1);
        }
        catch (SQLException sQLException) {
            throw new EventDataException("Error accessing column " + n + " " + sQLException);
        }
    }

    public Date getDate(int n) {
        try {
            return this.m_rset.getTimestamp(n + 1);
        }
        catch (SQLException sQLException) {
            throw new EventDataException("Error accessing column " + n + " " + sQLException);
        }
    }

    public String getString(int n) {
        try {
            return this.m_rset.getString(n + 1);
        }
        catch (SQLException sQLException) {
            throw new EventDataException("Error accessing column " + n + " " + sQLException);
        }
    }

    public boolean getBoolean(int n) {
        try {
            return this.m_rset.getBoolean(n + 1);
        }
        catch (SQLException sQLException) {
            throw new EventDataException("Error accessing column " + n + " " + sQLException);
        }
    }

    public Object getObject(int n) {
        try {
            return this.m_rset.getObject(n + 1);
        }
        catch (SQLException sQLException) {
            throw new EventDataException("Error accessing column " + n + " " + sQLException);
        }
    }

    public int findColumn(String string) {
        try {
            return this.m_rset.findColumn(string + 1);
        }
        catch (SQLException sQLException) {
            throw new EventDataException("Error finding column " + string + " " + sQLException);
        }
    }
}

