/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.jets;

import hep.physics.HepLorentzVector;
import hep.physics.jets.AbstractJetFinder;
import hep.physics.jets.JadeEJetFinder;
import hep.physics.jets.JetFinder;
import hep.physics.predicate.Predicate;
import java.util.Enumeration;

public class FixNumberOfJetsFinder
implements JetFinder {
    private AbstractJetFinder m_jetFinder = new JadeEJetFinder(0.01);
    private int m_nReqJets = 2;
    private double m_ycut = -1.0;
    private boolean m_resultsValid = false;

    public FixNumberOfJetsFinder() {
    }

    public FixNumberOfJetsFinder(int n) {
        this.setNJets(n);
    }

    public FixNumberOfJetsFinder(AbstractJetFinder abstractJetFinder) {
        this.setJetFinder(abstractJetFinder);
    }

    public FixNumberOfJetsFinder(int n, AbstractJetFinder abstractJetFinder) {
        this.setJetFinder(abstractJetFinder);
        this.setNJets(n);
    }

    protected void setJetFinder(AbstractJetFinder abstractJetFinder) {
        if (abstractJetFinder == null) {
            throw new IllegalArgumentException("FixNumberOfJetsFinder: no JetFinder defined!");
        }
        this.m_jetFinder = abstractJetFinder;
        this.m_resultsValid = false;
    }

    public void setNJets(int n) {
        if (n != this.m_nReqJets) {
            this.m_resultsValid = false;
        }
        this.m_nReqJets = n;
    }

    public int njets() {
        if (!this.m_resultsValid) {
            this.doFindJets();
        }
        return this.m_jetFinder.njets();
    }

    public double getYCut() {
        if (!this.m_resultsValid) {
            this.doFindJets();
        }
        return this.m_ycut;
    }

    public HepLorentzVector jet(int n) {
        if (!this.m_resultsValid) {
            this.doFindJets();
        }
        return this.m_jetFinder.jet(n);
    }

    public Enumeration particlesInJet(int n) {
        if (!this.m_resultsValid) {
            this.doFindJets();
        }
        return this.m_jetFinder.particlesInJet(n);
    }

    public int nParticlesPerJet(int n) {
        if (!this.m_resultsValid) {
            this.doFindJets();
        }
        return this.m_jetFinder.nParticlesPerJet(n);
    }

    public int fewestTracks() {
        if (!this.m_resultsValid) {
            this.doFindJets();
        }
        return this.m_jetFinder.fewestTracks();
    }

    public void setEvent(Enumeration enumeration) {
        this.setEvent(enumeration, null);
    }

    public void setEvent(Enumeration enumeration, Predicate predicate) {
        this.m_resultsValid = false;
        this.m_jetFinder.setEvent(enumeration);
    }

    private void doFindJets() {
        double d = 0.5;
        int n = -1;
        double d2 = 0.999999;
        double d3 = 1.0E-6;
        while (n != this.m_nReqJets) {
            d = d3 + 0.5 * (d3 + d2);
            this.m_jetFinder.setYCut(d);
            n = this.m_jetFinder.njets();
            if (n > this.m_nReqJets) {
                d3 = d;
            }
            if (n >= this.m_nReqJets) continue;
            d2 = d;
        }
        this.m_ycut = d;
        this.m_resultsValid = true;
    }
}

