/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.jets;

import hep.physics.BasicHep3Vector;
import hep.physics.Hep3Vector;
import hep.physics.HepLorentzVector;
import hep.physics.predicate.Predicate;
import java.util.Enumeration;

public class EventShape {
    private double m_dSphMomPower = 2.0;
    private double m_dDeltaThPower = 0.0;
    private int m_iFast = 4;
    private double m_dConv = 1.0E-4;
    private int m_iGood = 2;
    private double[][] m_dAxes = new double[4][4];
    private double[] m_dThrust = new double[4];
    private double m_dOblateness;
    private BasicHep3Vector m_EigenVector1;
    private BasicHep3Vector m_EigenVector2;
    private BasicHep3Vector m_EigenVector3;
    private double m_dEigenValue1;
    private double m_dEigenValue2;
    private double m_dEigneValue3;
    private static final int m_maxpart = 1000;

    public void setEvent(Enumeration enumeration) {
        this.setEvent(enumeration, null);
    }

    public void setEvent(Enumeration enumeration, Predicate predicate) {
        double d;
        double d2;
        int n;
        int n2;
        double[][] dArray = new double[1000][6];
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double[][] dArray2 = new double[this.m_iFast + 1][6];
        double[][] dArray3 = new double[11][6];
        double[] dArray4 = new double[4];
        double[] dArray5 = new double[4];
        double[][] dArray6 = new double[3][5];
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            Hep3Vector hep3Vector;
            Object e = enumeration.nextElement();
            if (predicate != null && !predicate.accept(e)) continue;
            if (n3 >= 1000) {
                throw new RuntimeException("Too many particles input to EventShape");
            }
            if (e instanceof Hep3Vector) {
                hep3Vector = (Hep3Vector)e;
            } else if (e instanceof HepLorentzVector) {
                HepLorentzVector hepLorentzVector = (HepLorentzVector)e;
                hep3Vector = hepLorentzVector.v3();
            } else {
                throw new RuntimeException("Element input to EventShape is not a Hep3Vector or an HepLorentzVector");
            }
            dArray[n3][1] = hep3Vector.x();
            dArray[n3][2] = hep3Vector.y();
            dArray[n3][3] = hep3Vector.z();
            dArray[n3][4] = hep3Vector.mag();
            dArray[n3][5] = Math.abs(this.m_dDeltaThPower) <= 0.001 ? 1.0 : Math.pow(dArray[n3][4], this.m_dDeltaThPower);
            d3 += dArray[n3][4] * dArray[n3][5];
            ++n3;
        }
        if (n3 < 2) {
            this.m_dThrust[1] = -1.0;
            this.m_dOblateness = -1.0;
            return;
        }
        int n4 = 1;
        while (n4 < 3) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            if (n4 == 2) {
                d4 = this.ulAngle(this.m_dAxes[1][1], this.m_dAxes[1][2]);
                this.ludbrb(dArray, 0.0, -d4, 0.0, 0.0, 0.0);
                int n10 = 0;
                while (n10 < 3) {
                    int n11 = 1;
                    while (n11 < 4) {
                        dArray6[n10][n11] = this.m_dAxes[n10 + 1][n11];
                        ++n11;
                    }
                    dArray6[n10][4] = 0.0;
                    ++n10;
                }
                this.ludbrb(dArray6, 0.0, -d4, 0.0, 0.0, 0.0);
                int n12 = 0;
                while (n12 < 3) {
                    n2 = 1;
                    while (n2 < 4) {
                        this.m_dAxes[n12 + 1][n2] = dArray6[n12][n2];
                        ++n2;
                    }
                    ++n12;
                }
                d5 = this.ulAngle(this.m_dAxes[1][3], this.m_dAxes[1][1]);
                this.ludbrb(dArray, -d5, 0.0, 0.0, 0.0, 0.0);
                n2 = 0;
                while (n2 < 3) {
                    n = 1;
                    while (n < 4) {
                        dArray6[n2][n] = this.m_dAxes[n2 + 1][n];
                        ++n;
                    }
                    dArray6[n2][4] = 0.0;
                    ++n2;
                }
                this.ludbrb(dArray6, -d5, 0.0, 0.0, 0.0, 0.0);
                n = 0;
                while (n < 3) {
                    n9 = 1;
                    while (n9 < 4) {
                        this.m_dAxes[n + 1][n9] = dArray6[n][n9];
                        ++n9;
                    }
                    ++n;
                }
            }
            int n13 = 0;
            while (n13 < this.m_iFast + 1) {
                dArray2[n13][4] = 0.0;
                ++n13;
            }
            int n14 = 0;
            while (n14 < n3) {
                if (n4 == 2) {
                    dArray[n14][4] = Math.sqrt(dArray[n14][1] * dArray[n14][1] + dArray[n14][2] * dArray[n14][2]);
                }
                n2 = this.m_iFast - 1;
                while (n2 > -1) {
                    if (!(dArray[n14][4] > dArray2[n2][4])) {
                        n = 1;
                        while (n < 6) {
                            dArray2[n2 + 1][n] = dArray[n14][n];
                            ++n;
                        }
                        break;
                    }
                    n = 1;
                    while (n < 6) {
                        dArray2[n2 + 1][n] = dArray2[n2][n];
                        if (n2 == 0) {
                            dArray2[n2][n] = dArray[n14][n];
                        }
                        ++n;
                    }
                    --n2;
                }
                ++n14;
            }
            n2 = 0;
            while (n2 < dArray3.length) {
                dArray3[n2][4] = 0.0;
                ++n2;
            }
            n = Math.min(this.m_iFast, n3) - 1;
            n9 = this.iPow(2, n);
            int n15 = 0;
            while (n15 < n9) {
                n8 = 1;
                while (n8 < 4) {
                    dArray4[n8] = 0.0;
                    ++n8;
                }
                n7 = 0;
                while (n7 < Math.min(this.m_iFast, n15)) {
                    d2 = dArray2[n7][5];
                    if (this.iPow(2, n7 + 1) * ((n15 + this.iPow(2, n7)) / this.iPow(2, n7 + 1)) >= n7 + 1) {
                        d2 = -d2;
                    }
                    n6 = 1;
                    while (n6 < 5 - n4) {
                        dArray4[n6] = dArray4[n6] + d2 * dArray2[n7][n6];
                        ++n6;
                    }
                    ++n7;
                }
                double d6 = dArray4[1] * dArray4[1] + dArray4[2] * dArray4[2] + dArray4[3] * dArray4[3];
                n6 = Math.min(n15, 9);
                while (n6 > -1) {
                    if (d6 > dArray3[n6][4]) {
                        n5 = 1;
                        while (n5 < 5) {
                            dArray3[n6 + 1][n5] = dArray3[n6][n5];
                            if (n6 == 0) {
                                dArray3[n6][n5] = n5 < 4 ? dArray4[n5] : d6;
                            }
                            ++n5;
                        }
                    } else {
                        n5 = 1;
                        while (n5 < 4) {
                            dArray3[n6 + 1][n5] = dArray4[n5];
                            ++n5;
                        }
                        dArray3[n6 + 1][4] = d6;
                    }
                    --n6;
                }
                ++n15;
            }
            this.m_dThrust[n4] = 0.0;
            d = -99999.0;
            n8 = 0;
            n7 = 0;
            while (n7 < Math.min(n9, 10) && n8 < this.m_iGood) {
                d = 0.0;
                double d7 = -99999.0;
                while (d > d7 + this.m_dConv) {
                    d7 = d;
                    n6 = 1;
                    while (n6 < 4) {
                        if (d <= 1.0E-10) {
                            dArray4[n6] = dArray3[n7][n6];
                        } else {
                            dArray4[n6] = dArray5[n6];
                            dArray5[n6] = 0.0;
                        }
                        ++n6;
                    }
                    n5 = 0;
                    while (n5 < n3) {
                        d2 = this.sign(dArray[n5][5], dArray4[1] * dArray[n5][1] + dArray4[2] * dArray[n5][2] + dArray4[3] * dArray[n5][3]);
                        int n16 = 1;
                        while (n16 < 5 - n4) {
                            dArray5[n16] = dArray5[n16] + d2 * dArray[n5][n16];
                            ++n16;
                        }
                        ++n5;
                    }
                    d = Math.sqrt(dArray5[1] * dArray5[1] + dArray5[2] * dArray5[2] + dArray5[3] * dArray5[3]) / d3;
                }
                if (d < this.m_dThrust[n4] - this.m_dConv) break;
                if (d > this.m_dThrust[n4] + this.m_dConv) {
                    n8 = 0;
                    d2 = this.iPow(-1, (int)Math.round(Math.random()));
                    n6 = 1;
                    while (n6 < 4) {
                        this.m_dAxes[n4][n6] = d2 * dArray5[n6] / (d3 * d);
                        ++n6;
                    }
                    this.m_dThrust[n4] = d;
                }
                ++n8;
                ++n7;
            }
            ++n4;
        }
        d2 = this.iPow(-1, (int)Math.round(Math.random()));
        this.m_dAxes[3][1] = -d2 * this.m_dAxes[2][2];
        this.m_dAxes[3][2] = d2 * this.m_dAxes[2][1];
        this.m_dAxes[3][3] = 0.0;
        d = 0.0;
        int n17 = 0;
        while (n17 < n3) {
            d += dArray[n17][5] * Math.abs(this.m_dAxes[3][1] * dArray[n17][1] + this.m_dAxes[3][2] * dArray[n17][2]);
            ++n17;
        }
        this.m_dThrust[3] = d / d3;
        int n18 = 0;
        while (n18 < 3) {
            n2 = 1;
            while (n2 < 4) {
                dArray6[n18][n2] = this.m_dAxes[n18 + 1][n2];
                ++n2;
            }
            dArray6[n18][4] = 0.0;
            ++n18;
        }
        this.ludbrb(dArray6, d5, d4, 0.0, 0.0, 0.0);
        n2 = 0;
        while (n2 < 3) {
            n = 1;
            while (n < 4) {
                this.m_dAxes[n2 + 1][n] = dArray6[n2][n];
                ++n;
            }
            ++n2;
        }
        this.m_dOblateness = this.m_dThrust[2] - this.m_dThrust[3];
    }

    public void setThMomPower(double d) {
        if (d > 0.0) {
            this.m_dDeltaThPower = d - 1.0;
        }
    }

    public double getThMomPower() {
        return 1.0 + this.m_dDeltaThPower;
    }

    public void setFast(int n) {
        if (n > 3) {
            this.m_iFast = n;
        }
    }

    public int getFast() {
        return this.m_iFast;
    }

    public BasicHep3Vector thrustAxis() {
        return new BasicHep3Vector(this.m_dAxes[1][1], this.m_dAxes[1][2], this.m_dAxes[1][3]);
    }

    public BasicHep3Vector majorAxis() {
        return new BasicHep3Vector(this.m_dAxes[2][1], this.m_dAxes[2][2], this.m_dAxes[2][3]);
    }

    public BasicHep3Vector minorAxis() {
        return new BasicHep3Vector(this.m_dAxes[3][1], this.m_dAxes[3][2], this.m_dAxes[3][3]);
    }

    public BasicHep3Vector thrust() {
        return new BasicHep3Vector(this.m_dThrust[1], this.m_dThrust[2], this.m_dThrust[3]);
    }

    public double oblateness() {
        return this.m_dOblateness;
    }

    private double ulAngle(double d, double d2) {
        double d3 = 0.0;
        double d4 = Math.sqrt(d * d + d2 * d2);
        if (d4 < 1.0E-20) {
            return d3;
        }
        if (Math.abs(d) / d4 < 0.8) {
            d3 = this.sign(Math.acos(d / d4), d2);
        } else {
            d3 = Math.asin(d2 / d4);
            if (d < 0.0 && d3 >= 0.0) {
                d3 = Math.PI - d3;
            } else if (d < 0.0) {
                d3 = -Math.PI - d3;
            }
        }
        return d3;
    }

    private double sign(double d, double d2) {
        if (d2 < 0.0) {
            return -Math.abs(d);
        }
        return Math.abs(d);
    }

    private void ludbrb(double[][] dArray, double d, double d2, double d3, double d4, double d5) {
        double[][] dArray2 = new double[4][4];
        double[] dArray3 = new double[4];
        double[] dArray4 = new double[5];
        int n = dArray.length;
        if (d * d + d2 * d2 > 1.0E-20) {
            dArray2[1][1] = Math.cos(d) * Math.cos(d2);
            dArray2[1][2] = -Math.sin(d2);
            dArray2[1][3] = Math.sin(d) * Math.cos(d2);
            dArray2[2][1] = Math.cos(d) * Math.sin(d2);
            dArray2[2][2] = Math.cos(d2);
            dArray2[2][3] = Math.sin(d) * Math.sin(d2);
            dArray2[3][1] = -Math.sin(d);
            dArray2[3][2] = 0.0;
            dArray2[3][3] = Math.cos(d);
            int n2 = 0;
            while (n2 < n) {
                int n3 = 1;
                while (n3 < 4) {
                    dArray3[n3] = dArray[n2][n3];
                    dArray[n2][n3] = 0.0;
                    ++n3;
                }
                int n4 = 1;
                while (n4 < 4) {
                    int n5 = 1;
                    while (n5 < 4) {
                        dArray[n2][n4] = dArray[n2][n4] + dArray2[n4][n5] * dArray3[n5];
                        ++n5;
                    }
                    ++n4;
                }
                ++n2;
            }
            double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
            if (d6 * d6 > 1.0E-20) {
                if (d6 > 0.99999999) {
                    d3 *= 0.99999999 / d6;
                    d4 *= 0.99999999 / d6;
                    d5 *= 0.99999999 / d6;
                    d6 = 0.99999999;
                }
                double d7 = 1.0 / Math.sqrt(1.0 - d6 * d6);
                int n6 = 0;
                while (n6 < n) {
                    int n7 = 1;
                    while (n7 < 5) {
                        dArray4[n7] = dArray[n6][n7];
                        ++n7;
                    }
                    double d8 = d3 * dArray4[1] + d4 * dArray4[2] + d5 * dArray4[3];
                    double d9 = d7 * (d7 * d8 / (1.0 + d7) + dArray4[4]);
                    dArray[n6][1] = dArray4[1] + d9 * d3;
                    dArray[n6][2] = dArray4[2] + d9 * d4;
                    dArray[n6][3] = dArray4[3] + d9 * d5;
                    dArray[n6][4] = d7 * (dArray4[4] + d8);
                    ++n6;
                }
            }
        }
    }

    private int iPow(int n, int n2) {
        int n3 = 1;
        int n4 = 0;
        while (n4 < n2) {
            n3 *= n;
            ++n4;
        }
        return n3;
    }
}

