/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.jets;

import hep.physics.BasicHepLorentzVector;
import hep.physics.Hep3Vector;
import hep.physics.HepLorentzVector;
import hep.physics.VecOp;
import hep.physics.jets.JetFinder;
import hep.physics.predicate.Predicate;
import java.util.Enumeration;
import java.util.Vector;

public abstract class AbstractJetFinder
implements JetFinder {
    private static double defaultMassSquared = 0.0;
    private static final int UNASSOC = -999;
    private int m_injets;
    private HepLorentzVector[] m_jet;
    private int[] m_ipart_jet_assoc;
    private int[] m_inparts_per_jet;
    private int m_ifewest_tracks;
    private double m_dycut;
    private boolean m_resultsValid = false;
    private final Vector m_in = new Vector();
    private final Vector m_4vec = new Vector();
    private double m_devis = 0.0;
    protected int m_np;
    protected HepLorentzVector[] m_part;
    protected double[][] ymass;

    abstract double masscut(double var1, double var3, double var5);

    abstract double calculate_mass(HepLorentzVector var1, HepLorentzVector var2);

    abstract void combine_particles(int var1, int var2);

    public int njets() {
        if (!this.m_resultsValid) {
            this.doFindJets();
        }
        return this.m_injets;
    }

    public HepLorentzVector jet(int n) {
        if (!this.m_resultsValid) {
            this.doFindJets();
        }
        return this.m_jet[n];
    }

    public Enumeration particlesInJet(int n) {
        if (!this.m_resultsValid) {
            this.doFindJets();
        }
        return new ParticlesInJetEnumeration(n);
    }

    public int nParticlesPerJet(int n) {
        if (!this.m_resultsValid) {
            this.doFindJets();
        }
        return this.m_inparts_per_jet[n];
    }

    public int fewestTracks() {
        if (!this.m_resultsValid) {
            this.doFindJets();
        }
        return this.m_ifewest_tracks;
    }

    protected AbstractJetFinder(double d) {
        this.m_dycut = d;
        this.m_resultsValid = false;
    }

    public double getYCut() {
        return this.m_dycut;
    }

    public void setYCut(double d) {
        if (this.m_dycut != d) {
            this.m_resultsValid = false;
        }
        this.m_dycut = d;
    }

    public void setEvent(Enumeration enumeration) {
        this.setEvent(enumeration, null);
    }

    public static void setAssumedMassFor3Vectors(double d) {
        defaultMassSquared = d * d;
    }

    public void setEvent(Enumeration enumeration, Predicate predicate) {
        this.m_resultsValid = false;
        this.m_in.removeAllElements();
        this.m_4vec.removeAllElements();
        this.m_devis = 0.0;
        while (enumeration.hasMoreElements()) {
            Object object;
            Object e = enumeration.nextElement();
            if (predicate != null && !predicate.accept(e)) continue;
            if (e instanceof HepLorentzVector) {
                object = (HepLorentzVector)e;
                this.m_devis += object.t();
                this.m_in.addElement(object);
                this.m_4vec.addElement(object);
                continue;
            }
            if (e instanceof Hep3Vector) {
                object = (Hep3Vector)e;
                double d = Math.sqrt(object.mag2() + defaultMassSquared);
                this.m_devis += d;
                this.m_in.addElement(object);
                this.m_4vec.addElement(new BasicHepLorentzVector(d, (Hep3Vector)object));
                continue;
            }
            throw new IllegalArgumentException("Element input to JetFinder is not a IHep3Vector or an IHepLorentzVector");
        }
        this.m_np = this.m_4vec.size();
        this.m_part = new HepLorentzVector[this.m_np];
    }

    private void doFindJets() {
        int n;
        int n2;
        int n3;
        this.m_resultsValid = true;
        this.m_injets = 0;
        if (this.m_np < 2) {
            return;
        }
        this.m_ipart_jet_assoc = new int[this.m_np];
        int n4 = 0;
        while (n4 < this.m_np) {
            this.m_ipart_jet_assoc[n4] = -999;
            ++n4;
        }
        this.m_4vec.copyInto(this.m_part);
        double d = this.m_devis;
        this.ymass = new double[this.m_np][this.m_np];
        int n5 = 0;
        while (n5 < this.m_np - 1) {
            n3 = n5 + 1;
            while (n3 < this.m_np) {
                double d2 = this.calculate_mass(this.m_part[n5], this.m_part[n3]);
                this.ymass[n5][n3] = d2 != -9999.0 ? d2 : 0.0;
                ++n3;
            }
            ++n5;
        }
        block3: while (true) {
            int n6;
            n3 = -1;
            n2 = -1;
            double d3 = Double.MAX_VALUE;
            n = 0;
            while (n < this.m_np - 1) {
                if (this.m_ipart_jet_assoc[n] == -999) {
                    n6 = n + 1;
                    while (n6 < this.m_np) {
                        if (this.m_ipart_jet_assoc[n6] == -999 && this.ymass[n][n6] < d3) {
                            d3 = this.ymass[n][n6];
                            n3 = n;
                            n2 = n6;
                        }
                        ++n6;
                    }
                }
                ++n;
            }
            if (d3 > this.masscut(this.m_dycut, this.m_devis, d)) break;
            this.combine_particles(n3, n2);
            this.m_ipart_jet_assoc[n2] = n3;
            n6 = 0;
            while (n6 < this.m_np) {
                if (this.m_ipart_jet_assoc[n6] == n2) {
                    this.m_ipart_jet_assoc[n6] = n3;
                }
                ++n6;
            }
            d = 0.0;
            int n7 = 0;
            while (true) {
                if (n7 >= this.m_np) continue block3;
                if (this.m_ipart_jet_assoc[n7] == -999) {
                    int n8;
                    int n9;
                    double d4;
                    d += this.m_part[n7].t();
                    if (n7 != n3 && (d4 = this.calculate_mass(this.m_part[n9 = Math.min(n7, n3)], this.m_part[n8 = Math.max(n7, n3)])) >= 0.0) {
                        this.ymass[n9][n8] = d4;
                    }
                }
                ++n7;
            }
            break;
        }
        n3 = 0;
        while (n3 < this.m_np) {
            if (this.m_ipart_jet_assoc[n3] == -999) {
                ++this.m_injets;
            }
            ++n3;
        }
        this.m_jet = new HepLorentzVector[this.m_injets];
        this.m_inparts_per_jet = new int[this.m_injets];
        n2 = 0;
        this.m_ifewest_tracks = Integer.MAX_VALUE;
        int n10 = 0;
        while (n10 < this.m_np) {
            if (this.m_ipart_jet_assoc[n10] == -999) {
                this.m_jet[n2] = this.m_part[n10];
                int n11 = 1;
                n = 0;
                while (n < this.m_np) {
                    if (this.m_ipart_jet_assoc[n] == n10) {
                        this.m_ipart_jet_assoc[n] = n2;
                        ++n11;
                    }
                    ++n;
                }
                this.m_ipart_jet_assoc[n10] = n2;
                this.m_inparts_per_jet[n2] = n11;
                if (n11 < this.m_ifewest_tracks) {
                    this.m_ifewest_tracks = n11;
                }
                ++n2;
            }
            ++n10;
        }
    }

    protected double standard_masscut(double d, double d2) {
        return d * d2 * d2;
    }

    protected double geneva_masscut(double d) {
        return d;
    }

    protected double jadeP0_masscut(double d, double d2) {
        return d * d2 * d2;
    }

    protected void four_vector_combine(int n, int n2) {
        this.m_part[n] = VecOp.add(this.m_part[n], this.m_part[n2]);
    }

    protected void jadeP_combine(int n, int n2) {
        Hep3Vector hep3Vector = VecOp.add(this.m_part[n].v3(), this.m_part[n2].v3());
        this.m_part[n] = new BasicHepLorentzVector(hep3Vector.mag(), hep3Vector);
    }

    protected void jadeE0_combine(int n, int n2) {
        HepLorentzVector hepLorentzVector = VecOp.add(this.m_part[n], this.m_part[n2]);
        double d = hepLorentzVector.t() / hepLorentzVector.v3().mag();
        this.m_part[n] = new BasicHepLorentzVector(hepLorentzVector.t(), VecOp.mult(d, this.m_part[n].v3()));
    }

    protected double four_vector_mass(HepLorentzVector hepLorentzVector, HepLorentzVector hepLorentzVector2) {
        return VecOp.add(hepLorentzVector, hepLorentzVector2).lorMag2();
    }

    protected double jade_mass(HepLorentzVector hepLorentzVector, HepLorentzVector hepLorentzVector2) {
        double d = hepLorentzVector.t();
        double d2 = hepLorentzVector2.t();
        Hep3Vector hep3Vector = hepLorentzVector.v3();
        Hep3Vector hep3Vector2 = hepLorentzVector2.v3();
        double d3 = VecOp.dot(hep3Vector, hep3Vector2) / (hep3Vector.mag() * hep3Vector2.mag());
        return 2.0 * d * d2 * (1.0 - d3);
    }

    protected double durham_mass(HepLorentzVector hepLorentzVector, HepLorentzVector hepLorentzVector2) {
        double d = hepLorentzVector.t();
        double d2 = hepLorentzVector2.t();
        Hep3Vector hep3Vector = hepLorentzVector.v3();
        Hep3Vector hep3Vector2 = hepLorentzVector2.v3();
        double d3 = VecOp.dot(hep3Vector, hep3Vector2) / (hep3Vector.mag() * hep3Vector2.mag());
        double d4 = Math.min(d, d2);
        return 2.0 * d4 * d4 * (1.0 - d3);
    }

    protected double geneva_mass(HepLorentzVector hepLorentzVector, HepLorentzVector hepLorentzVector2) {
        double d;
        double d2 = hepLorentzVector.t();
        if (d2 == 0.0 & (d = hepLorentzVector2.t()) == 0.0) {
            return -9999.0;
        }
        Hep3Vector hep3Vector = hepLorentzVector.v3();
        Hep3Vector hep3Vector2 = hepLorentzVector2.v3();
        double d3 = VecOp.dot(hep3Vector, hep3Vector2) / (hep3Vector.mag() * hep3Vector2.mag());
        return 0.8888888888888888 * (1.0 - d3) * (d2 * d) / ((d2 + d) * (d2 + d));
    }

    private class ParticlesInJetEnumeration
    implements Enumeration {
        private int next = 0;
        private int i = -1;
        private final int index;

        ParticlesInJetEnumeration(int n) {
            this.index = n;
        }

        public Object nextElement() {
            if (this.next >= AbstractJetFinder.this.m_inparts_per_jet[this.index]) {
                throw new RuntimeException("No more particles in Enumeration");
            }
            ++this.i;
            while (AbstractJetFinder.this.m_ipart_jet_assoc[this.i] != this.index) {
                ++this.i;
            }
            ++this.next;
            return AbstractJetFinder.this.m_in.elementAt(this.i);
        }

        public boolean hasMoreElements() {
            return this.next < AbstractJetFinder.this.m_inparts_per_jet[this.index];
        }
    }
}

