/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.generator.event;

import hep.physics.Hep3Vector;
import hep.physics.HepLorentzVector;
import hep.physics.Particle;
import hep.physics.ParticleEnumeration;
import hep.physics.ParticleType;
import hep.physics.generator.event.GeneratorParticleVector;

public class GeneratorParticle
implements Particle {
    private double m_dpX;
    private double m_dpY;
    private double m_dpZ;
    private double m_denergy;
    private double m_doriginX;
    private double m_doriginY;
    private double m_doriginZ;
    private double m_productionTime;
    private int m_statusCode;
    private ParticleType m_pType;
    private GeneratorParticleVector m_parents;
    private GeneratorParticleVector m_daughters = new GeneratorParticleVector();

    public GeneratorParticle() {
        this.m_parents = new GeneratorParticleVector();
    }

    public void setStatusCode(int n) {
        this.m_statusCode = n;
    }

    public void setProductionTime(double d) {
        this.m_productionTime = d;
    }

    public void setType(ParticleType particleType) {
        this.m_pType = particleType;
    }

    public void setOrigin(Hep3Vector hep3Vector) {
        this.m_doriginX = hep3Vector.x();
        this.m_doriginY = hep3Vector.y();
        this.m_doriginZ = hep3Vector.z();
    }

    public void setP(HepLorentzVector hepLorentzVector) {
        this.m_dpX = hepLorentzVector.v3().x();
        this.m_dpY = hepLorentzVector.v3().y();
        this.m_dpZ = hepLorentzVector.v3().z();
        this.m_denergy = hepLorentzVector.t();
    }

    public double getPX() {
        return this.m_dpX;
    }

    public double getPY() {
        return this.m_dpY;
    }

    public double getPZ() {
        return this.m_dpZ;
    }

    public double getEnergy() {
        return this.m_denergy;
    }

    public double getMass() {
        return this.m_pType.getMass();
    }

    public double getOriginX() {
        return this.m_doriginX;
    }

    public double getOriginY() {
        return this.m_doriginY;
    }

    public double getOriginZ() {
        return this.m_doriginZ;
    }

    public double getProductionTime() {
        return this.m_productionTime;
    }

    public int getStatusCode() {
        return this.m_statusCode;
    }

    public double[] getMomentum() {
        double[] dArray = new double[]{this.getPX(), this.getPY(), this.getPZ()};
        return dArray;
    }

    public double[] getOrigin() {
        double[] dArray = new double[]{this.getOriginX(), this.getOriginY(), this.getOriginZ()};
        return dArray;
    }

    public ParticleEnumeration getDaughters() {
        return this.m_daughters.particles();
    }

    public Particle getParent() {
        if (this.m_parents.isEmpty()) {
            return null;
        }
        if (this.m_parents.size() == 1) {
            return (Particle)this.m_parents.elementAt(0);
        }
        throw new RuntimeException("Invalid call to getParent for Particle with >1 parent. Use getParents() instead");
    }

    public ParticleEnumeration getParents() {
        return this.m_parents.particles();
    }

    public ParticleType getType() {
        return this.m_pType;
    }

    public void addParent(GeneratorParticle generatorParticle) {
        this.m_parents.addElement(generatorParticle);
        generatorParticle.IAmYourDaughter(this);
    }

    private void IAmYourDaughter(GeneratorParticle generatorParticle) {
        this.m_daughters.addElement(generatorParticle);
    }
}

