/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.generator.diagnostic;

import hep.analysis.EndOfDataException;
import hep.analysis.EventData;
import hep.analysis.EventGenerator;
import hep.physics.BasicHep3Matrix;
import hep.physics.BasicHep3Vector;
import hep.physics.BasicHepLorentzVector;
import hep.physics.Hep3Vector;
import hep.physics.HepLorentzVector;
import hep.physics.ParticleProperties;
import hep.physics.ParticleType;
import hep.physics.UnknownParticleID;
import hep.physics.VecOp;
import hep.physics.generator.event.GeneratorEvent;
import hep.physics.generator.event.GeneratorParticle;
import hep.physics.generator.event.GeneratorParticleVector;
import java.util.Random;

public class DiagnosticEventGenerator
extends EventGenerator {
    private int m_imaxEvents = 100;
    private int m_ievent;
    private int m_irun = 1;
    private ParticleType m_ptype;
    private ParticleType m_ptypeBar;
    private int m_inparts = 1;
    private double m_dlowp = 5.0;
    private double m_dhighp = 5.0;
    private double m_dlowcosth = -1.0;
    private double m_dhighcosth = 1.0;
    private double m_dlowphi = 0.0;
    private double m_dhighphi = Math.PI * 2;
    private BasicHep3Vector m_origin = new BasicHep3Vector(0.0, 0.0, 0.0);
    private double m_dxrange = 0.0;
    private double m_dyrange = 0.0;
    private double m_dzrange = 0.0;
    private double m_dangres = -1.0;
    boolean m_bseedset = false;
    private long m_lseed;
    private Random myRandom;
    boolean m_branPPBar = false;
    boolean m_addFakeMother = true;

    public DiagnosticEventGenerator() {
        this.setParticleType(13);
        this.myRandom = new Random();
    }

    public String getName() {
        return "Diagnostic Generator";
    }

    public void beforeFirstEvent() {
        this.m_bseedset = true;
        if (true) {
            this.myRandom.setSeed(this.m_lseed);
        }
        this.m_ievent = 0;
    }

    public void setMaxEvents(int n) {
        this.m_imaxEvents = n;
    }

    public int getMaxEvents() {
        return this.m_imaxEvents;
    }

    public int getTotalNumberOfEvents() {
        return this.m_imaxEvents > 0 ? this.m_imaxEvents : -1;
    }

    public void setRunNumber(int n) {
        this.m_irun = n;
    }

    public void setParticleType(int n) {
        this.setParticleType(ParticleProperties.get(n));
    }

    public void setParticleType(ParticleType particleType) {
        this.m_ptype = particleType;
        try {
            this.m_ptypeBar = ParticleProperties.get(-1 * particleType.getPDGID());
            this.m_ptypeBar.getMass();
        }
        catch (UnknownParticleID unknownParticleID) {
            this.m_ptypeBar = particleType;
        }
    }

    public void addFakeMother(boolean bl) {
        this.m_addFakeMother = bl;
    }

    public ParticleType getParticleType() {
        return this.m_ptype;
    }

    public void setNumberOfParticles(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid number of particles.");
        }
        this.m_inparts = n;
    }

    public int getNumberOfParticles() {
        return this.m_inparts;
    }

    public void setMomentumRange(double d, double d2) {
        if (d < 0.0 | d2 <= 0.0 | d > d2) {
            throw new IllegalArgumentException("Invalid momentum range value.");
        }
        this.m_dlowp = d;
        this.m_dhighp = d2;
    }

    public void setCosthRange(double d, double d2) {
        if (d < -1.0 | d2 > 1.0 | d > d2) {
            throw new IllegalArgumentException("Invalid costheta range value.");
        }
        this.m_dlowcosth = d;
        this.m_dhighcosth = d2;
    }

    public void setPhiRange(double d, double d2) {
        if (d > d2) {
            throw new IllegalArgumentException("Invalid phi range value.");
        }
        this.m_dlowphi = d;
        this.m_dhighphi = d2;
    }

    public void setOrigin(double d, double d2, double d3) {
        this.m_origin.setV(d, d2, d3);
    }

    public void setXRange(double d) {
        this.m_dxrange = d;
    }

    public void setYRange(double d) {
        this.m_dyrange = d;
    }

    public void setZRange(double d) {
        this.m_dzrange = d;
    }

    public void setRandomParticleAntiParticle(boolean bl) {
        this.m_branPPBar = bl;
    }

    public void setTwoParticleRes(double d) {
        this.m_dangres = d;
    }

    public void setSeed(long l) {
        this.m_lseed = l;
        this.m_bseedset = true;
    }

    public void printParameters() {
        System.out.println("Diagnostic Generator Parameter Settings.");
        System.out.println("Particle type = " + this.m_ptype);
        System.out.println("Number of particles per event = " + this.m_inparts);
        System.out.println("Momentum range = (" + this.m_dlowp + ", " + this.m_dhighp + ")");
        System.out.println("Cosine theta range = (" + this.m_dlowcosth + ", " + this.m_dhighcosth + ")");
        System.out.println("Phi range = (" + this.m_dlowphi + ", " + this.m_dhighphi + ")");
        System.out.println("Particle origin = (" + this.m_origin.x() + ", " + this.m_origin.y() + ", " + this.m_origin.z() + ")");
        System.out.println("Origin ranges = (" + this.m_dxrange + ", " + this.m_dyrange + ", " + this.m_dzrange + ")");
        System.out.println("Angular resolution = " + this.m_dangres);
        System.out.println("Random number seed = " + this.m_lseed);
    }

    public EventData generateEvent() throws EndOfDataException {
        if (this.m_imaxEvents > 0 && this.m_ievent >= this.m_imaxEvents) {
            throw new EndOfDataException();
        }
        GeneratorParticleVector generatorParticleVector = this.m_dangres < 0.0 ? new GeneratorParticleVector(this.m_inparts + 1) : new GeneratorParticleVector(2 * this.m_inparts + 1);
        int n = 0;
        while (n < this.m_inparts) {
            GeneratorParticle generatorParticle = new GeneratorParticle();
            if (this.m_addFakeMother) {
                generatorParticle.setStatusCode(3);
                generatorParticle.setProductionTime(0.0);
                generatorParticle.setOrigin(new BasicHep3Vector(0.0, 0.0, 0.0));
                generatorParticle.setType(ParticleProperties.get(99999999));
                generatorParticle.setP(new BasicHepLorentzVector(0.0, 0.0, 0.0, 0.0));
                generatorParticleVector.addElement(generatorParticle);
            }
            GeneratorParticle generatorParticle2 = new GeneratorParticle();
            generatorParticle2.setStatusCode(1);
            generatorParticle2.setProductionTime(0.0);
            if (this.m_branPPBar && this.myRandom.nextDouble() < 0.5) {
                generatorParticle2.setType(this.m_ptypeBar);
            } else {
                generatorParticle2.setType(this.m_ptype);
            }
            Hep3Vector hep3Vector = this.selectOrigin();
            generatorParticle2.setOrigin(hep3Vector);
            HepLorentzVector hepLorentzVector = this.selectP();
            generatorParticle2.setP(hepLorentzVector);
            if (this.m_addFakeMother) {
                generatorParticle2.addParent(generatorParticle);
            }
            generatorParticleVector.addElement(generatorParticle2);
            if (this.m_dangres >= 0.0) {
                BasicHep3Vector basicHep3Vector = new BasicHep3Vector(0.0, 0.0, hepLorentzVector.v3().mag());
                double d = Math.PI * 2 * this.myRandom.nextDouble();
                BasicHep3Matrix basicHep3Matrix = new BasicHep3Matrix();
                basicHep3Matrix.setActiveEuler(d, this.m_dangres, 0.0);
                Hep3Vector hep3Vector2 = new BasicHep3Vector();
                hep3Vector2 = VecOp.mult(basicHep3Matrix, (Hep3Vector)basicHep3Vector);
                double d2 = Math.acos(hepLorentzVector.v3().z() / hepLorentzVector.v3().mag());
                BasicHep3Vector basicHep3Vector2 = new BasicHep3Vector(hepLorentzVector.v3().x(), hepLorentzVector.v3().y(), 0.0);
                double d3 = basicHep3Vector2.mag();
                int n2 = 1;
                if (hepLorentzVector.v3().y() < 0.0) {
                    n2 = -1;
                }
                double d4 = d3 > 0.0 ? (double)n2 * Math.acos(hepLorentzVector.v3().x() / d3) : 0.0;
                basicHep3Matrix.setActiveEuler(1.5707963267948966 + d4, d2, 0.0);
                BasicHepLorentzVector basicHepLorentzVector = new BasicHepLorentzVector(hepLorentzVector.t(), VecOp.mult(basicHep3Matrix, hep3Vector2));
                GeneratorParticle generatorParticle3 = new GeneratorParticle();
                generatorParticle3.setStatusCode(1);
                generatorParticle3.setProductionTime(0.0);
                if (this.m_branPPBar && this.myRandom.nextDouble() < 0.5) {
                    generatorParticle3.setType(this.m_ptypeBar);
                } else {
                    generatorParticle3.setType(this.m_ptype);
                }
                generatorParticle3.setOrigin(hep3Vector);
                generatorParticle3.setP(basicHepLorentzVector);
                if (this.m_addFakeMother) {
                    generatorParticle3.addParent(generatorParticle);
                }
                generatorParticleVector.addElement(generatorParticle3);
            }
            ++n;
        }
        ++this.m_ievent;
        return new GeneratorEvent(this.m_irun, this.m_ievent, generatorParticleVector);
    }

    public void getSummary() {
    }

    protected HepLorentzVector selectP() {
        double d = this.selectMom();
        double d2 = Math.acos(this.selectCosth());
        double d3 = this.selectPhi();
        double d4 = d * Math.sin(d2) * Math.cos(d3);
        double d5 = d * Math.sin(d2) * Math.sin(d3);
        double d6 = d * Math.cos(d2);
        double d7 = this.m_ptype.getMass();
        double d8 = Math.sqrt(d7 * d7 + d * d);
        return new BasicHepLorentzVector(d8, d4, d5, d6);
    }

    protected Hep3Vector selectOrigin() {
        double d = this.myRandom.nextDouble();
        double d2 = this.m_origin.x() + this.m_dxrange * (d - 0.5);
        d = this.myRandom.nextDouble();
        double d3 = this.m_origin.y() + this.m_dyrange * (d - 0.5);
        d = this.myRandom.nextDouble();
        double d4 = this.m_origin.z() + this.m_dzrange * (d - 0.5);
        BasicHep3Vector basicHep3Vector = new BasicHep3Vector(d2, d3, d4);
        return basicHep3Vector;
    }

    protected double selectMom() {
        if (this.m_dlowp == this.m_dhighp) {
            return this.m_dlowp;
        }
        if (this.m_dlowp > 0.0) {
            return this.m_dlowp + (this.m_dhighp - this.m_dlowp) * this.myRandom.nextDouble();
        }
        double d = 0.0;
        while (d == 0.0) {
            d = this.myRandom.nextDouble();
        }
        return this.m_dlowp + (this.m_dhighp - this.m_dlowp) * d;
    }

    protected double selectCosth() {
        if (this.m_dlowcosth == this.m_dhighcosth) {
            return this.m_dlowcosth;
        }
        return this.m_dlowcosth + (this.m_dhighcosth - this.m_dlowcosth) * this.myRandom.nextDouble();
    }

    protected double selectPhi() {
        if (this.m_dlowphi == this.m_dhighphi) {
            return this.m_dlowphi;
        }
        return this.m_dlowphi + (this.m_dhighphi - this.m_dlowphi) * this.myRandom.nextDouble();
    }
}

