/*
 * Decompiled with CFR 0.152.
 */
package hep.physics;

import hep.physics.BasicHep3Vector;
import hep.physics.BasicHepLorentzVector;
import hep.physics.Hep3Matrix;
import hep.physics.Hep3Vector;
import hep.physics.HepLorentzVector;
import java.util.Enumeration;

public class VecOp {
    private VecOp() {
    }

    public static Hep3Vector add(Hep3Vector hep3Vector, Hep3Vector hep3Vector2) {
        return new BasicHep3Vector(hep3Vector.x() + hep3Vector2.x(), hep3Vector.y() + hep3Vector2.y(), hep3Vector.z() + hep3Vector2.z());
    }

    public static Hep3Vector sub(Hep3Vector hep3Vector, Hep3Vector hep3Vector2) {
        return new BasicHep3Vector(hep3Vector.x() - hep3Vector2.x(), hep3Vector.y() - hep3Vector2.y(), hep3Vector.z() - hep3Vector2.z());
    }

    public static Hep3Vector mult(double d, Hep3Vector hep3Vector) {
        return new BasicHep3Vector(d * hep3Vector.x(), d * hep3Vector.y(), d * hep3Vector.z());
    }

    public static Hep3Vector mult(Hep3Matrix hep3Matrix, Hep3Vector hep3Vector) {
        double d = hep3Vector.x() * hep3Matrix.e(1, 1) + hep3Vector.y() * hep3Matrix.e(1, 2) + hep3Vector.z() * hep3Matrix.e(1, 3);
        double d2 = hep3Vector.x() * hep3Matrix.e(2, 1) + hep3Vector.y() * hep3Matrix.e(2, 2) + hep3Vector.z() * hep3Matrix.e(2, 3);
        double d3 = hep3Vector.x() * hep3Matrix.e(3, 1) + hep3Vector.y() * hep3Matrix.e(3, 2) + hep3Vector.z() * hep3Matrix.e(3, 3);
        return new BasicHep3Vector(d, d2, d3);
    }

    public static Hep3Vector neg(Hep3Vector hep3Vector) {
        return new BasicHep3Vector(-hep3Vector.x(), -hep3Vector.y(), -hep3Vector.z());
    }

    public static double dot(Hep3Vector hep3Vector, Hep3Vector hep3Vector2) {
        return hep3Vector.x() * hep3Vector2.x() + hep3Vector.y() * hep3Vector2.y() + hep3Vector.z() * hep3Vector2.z();
    }

    public static Hep3Vector cross(Hep3Vector hep3Vector, Hep3Vector hep3Vector2) {
        double d = hep3Vector.y() * hep3Vector2.z() - hep3Vector.z() * hep3Vector2.y();
        double d2 = hep3Vector.z() * hep3Vector2.x() - hep3Vector.x() * hep3Vector2.z();
        double d3 = hep3Vector.x() * hep3Vector2.y() - hep3Vector.y() * hep3Vector2.x();
        return new BasicHep3Vector(d, d2, d3);
    }

    public static Hep3Vector unit(Hep3Vector hep3Vector) {
        double d = hep3Vector.mag();
        if (d != 0.0) {
            return VecOp.mult(1.0 / d, hep3Vector);
        }
        return new BasicHep3Vector(0.0, 0.0, 0.0);
    }

    public static HepLorentzVector add(HepLorentzVector hepLorentzVector, HepLorentzVector hepLorentzVector2) {
        return new BasicHepLorentzVector(hepLorentzVector.t() + hepLorentzVector2.t(), VecOp.add(hepLorentzVector.v3(), hepLorentzVector2.v3()));
    }

    public static HepLorentzVector sub(HepLorentzVector hepLorentzVector, HepLorentzVector hepLorentzVector2) {
        return new BasicHepLorentzVector(hepLorentzVector.t() - hepLorentzVector2.t(), VecOp.sub(hepLorentzVector.v3(), hepLorentzVector2.v3()));
    }

    public static HepLorentzVector mult(double d, HepLorentzVector hepLorentzVector) {
        return new BasicHepLorentzVector(d * hepLorentzVector.t(), VecOp.mult(d, hepLorentzVector.v3()));
    }

    public static HepLorentzVector neg(HepLorentzVector hepLorentzVector) {
        return new BasicHepLorentzVector(-hepLorentzVector.t(), VecOp.neg(hepLorentzVector.v3()));
    }

    public static double dot(HepLorentzVector hepLorentzVector, HepLorentzVector hepLorentzVector2) {
        return hepLorentzVector.t() * hepLorentzVector2.t() - VecOp.dot(hepLorentzVector.v3(), hepLorentzVector2.v3());
    }

    public static Hep3Vector CM(Enumeration enumeration) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        Hep3Vector hep3Vector = new BasicHep3Vector();
        while (enumeration.hasMoreElements()) {
            Object object;
            if (bl) {
                bl = false;
                object = enumeration.nextElement();
                if (object instanceof Hep3Vector) {
                    bl2 = true;
                    hep3Vector = (Hep3Vector)object;
                    continue;
                }
                if (object instanceof HepLorentzVector) {
                    bl3 = true;
                    HepLorentzVector hepLorentzVector = (HepLorentzVector)object;
                    hep3Vector = hepLorentzVector.v3();
                    continue;
                }
                throw new RuntimeException("Element is not a 3- or 4-vector");
            }
            if (bl3) {
                try {
                    object = (HepLorentzVector)enumeration.nextElement();
                    hep3Vector = VecOp.add(hep3Vector, object.v3());
                    continue;
                }
                catch (ClassCastException classCastException) {
                    throw new RuntimeException("Element of 4Vec enumeration is not a 4Vec.");
                }
            }
            if (!bl2) continue;
            try {
                hep3Vector = VecOp.add(hep3Vector, (Hep3Vector)enumeration.nextElement());
            }
            catch (ClassCastException classCastException) {
                throw new RuntimeException("Element of 3Vec enumeration is not a 3Vec object.");
            }
        }
        if (!bl) {
            return hep3Vector;
        }
        throw new RuntimeException("CM:vector set is empty.");
    }

    public static HepLorentzVector boost(HepLorentzVector hepLorentzVector, Hep3Vector hep3Vector) {
        double d = hep3Vector.mag();
        if (d >= 1.0) {
            throw new RuntimeException("Boost beta >= 1.0 !");
        }
        double d2 = 1.0 / Math.sqrt(1.0 - d * d);
        double d3 = hepLorentzVector.t();
        Hep3Vector hep3Vector2 = hepLorentzVector.v3();
        double d4 = d2 * (d3 - VecOp.dot(hep3Vector, hep3Vector2));
        Hep3Vector hep3Vector3 = VecOp.add(hep3Vector2, VecOp.add(VecOp.mult((d2 - 1.0) / (d * d) * VecOp.dot(hep3Vector, hep3Vector2), hep3Vector), VecOp.mult(-d2 * d3, hep3Vector)));
        return new BasicHepLorentzVector(d4, hep3Vector3);
    }

    public static HepLorentzVector boost(HepLorentzVector hepLorentzVector, HepLorentzVector hepLorentzVector2) {
        Hep3Vector hep3Vector = hepLorentzVector2.v3();
        Hep3Vector hep3Vector2 = new BasicHep3Vector(hep3Vector.x(), hep3Vector.y(), hep3Vector.z());
        hep3Vector2 = VecOp.mult(1.0 / hepLorentzVector2.t(), hep3Vector2);
        return VecOp.boost(hepLorentzVector, hep3Vector2);
    }
}

