/*
 * Decompiled with CFR 0.152.
 */
package hep.physics;

import hep.physics.Particle;
import hep.physics.ParticleEnumeration;
import java.io.PrintStream;
import java.io.PrintWriter;

public class HEPUtilities {
    private HEPUtilities() {
    }

    public static void dumpParticleHierarchy(Particle particle) {
        HEPUtilities.dumpParticleHierarchy(particle, System.out);
    }

    public static void dumpParticleHierarchy(Particle particle, PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(printStream);
        HEPUtilities.dumpParticleHierarchy(particle, printWriter);
        printWriter.flush();
    }

    public static void dumpParticleHierarchy(Particle particle, PrintWriter printWriter) {
        HEPUtilities.dumpParticleHierarchy(particle, printWriter, "", "");
    }

    private static void dumpParticleHierarchy(Particle particle, PrintWriter printWriter, String string, String string2) {
        printWriter.println(string + string2 + particle.getType().toString());
        ParticleEnumeration particleEnumeration = particle.getDaughters();
        boolean bl = particleEnumeration.hasMoreParticles();
        while (bl) {
            Particle particle2 = particleEnumeration.nextParticle();
            bl = particleEnumeration.hasMoreParticles();
            HEPUtilities.dumpParticleHierarchy(particle2, printWriter, string + (string2.equals("+--") ? "|  " : "   "), bl ? "+--" : "\\--");
        }
    }
}

