/*
 * Decompiled with CFR 0.152.
 */
package hep.physics;

import hep.physics.ParticlePropertyProvider;
import hep.physics.ParticleType;
import hep.physics.UnknownParticleID;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;

public class DefaultParticlePropertyProvider
implements ParticlePropertyProvider {
    private Hashtable m_hash = new Hashtable();

    protected DefaultParticlePropertyProvider() {
        double d = 100.0;
        double d2 = 1.0;
        double d3 = 0.1;
        double d4 = 1.0;
        double d5 = 0.001;
        double d6 = 1.0E-6;
        double d7 = 197.327 * d5 * d * 1.0E-15;
        double d8 = 0.00299792;
        this.PART("HepEvt", 99999999, 0, 0, 0.0, 0.0);
        this.PART("NBeam", 9999999, 0, 0, 0.0, 0.0);
        this.PART("IDontknowino", "IDontknowino_bar", 123456789, 0, 0.0, 0.0, 0.0);
        this.INTERACT("electromagnetic");
        this.PART("gluon", "gluon_bar", 21, 2, 0.0, 0.0, 0.0);
        this.PART("gamma", 22, 2, 0, 0.0);
        this.PART("e-", "e+", 11, 1, -1.0, 511.0 * d6);
        this.INTERACT("weak");
        this.PART("mu-", "mu+", 13, 1, -1.0, 105.658 * d5, d7 / (658.65 * d));
        this.PART("tau-", "tau+", 15, 1, -1.0, 1.777 * d4, d7 / (8.72E-5 * d));
        this.PART("nu_e", "nu_e_bar", 12, 1, 0.0, 0.0);
        this.PART("nu_mu", "nu_mu_bar", 14, 1, 0.0, 0.0);
        this.PART("nu_tau", "nu_tau_bar", 16, 1, 0.0, 0.0, 0.0);
        this.PART("d", "d_bar", 1, 1, -0.3333333333333333, 6.0 * d5, 0.0);
        this.PART("u", "u_bar", 2, 1, 0.6666666666666666, 3.25 * d5, 0.0);
        this.PART("s", "s_bar", 3, 1, -0.3333333333333333, 115.0 * d5, 0.0);
        this.PART("c", "c_bar", 4, 1, 0.6666666666666666, 1.4 * d4, 0.0);
        this.PART("b", "b_bar", 5, 1, -0.3333333333333333, 4.25 * d4, 0.0);
        this.PART("t", "t_bar", 6, 1, 0.6666666666666666, 175.0 * d4, 0.0);
        this.PART("a1+", "a1-", 20213, 2, 0.0, 1.23 * d4, 400.0 * d5);
        this.PART("eta", "eta_bar", 221, 0, 0.0, 547.45 * d5, 0.0);
        this.PART("eta'", "eta'_bar", 331, 0, 0.0, 957.77 * d5, 0.201 * d5);
        this.PART("eta(c)(1S)", "eta(c)(1S)_bar", 441, 0, 0.0, 29.798 * d5, 13.2 * d5);
        this.PART("Delta+", "Delta+_bar", 2214, 3, 1.0, 1.232 * d4, 350.0 * d5);
        this.PART("Delta-", "Delta-_bar", 1114, 3, -1.0, 1.232 * d4, 350.0 * d5);
        this.PART("Deltao", "Deltao_bar", 2114, 3, 0.0, 1.232 * d4, 120.0 * d5);
        this.PART("Delta++", "Delta--", 2224, 3, 2.0, 1.232 * d4, 120.0 * d5);
        this.PART("Lambda(c)+", "Lambda(c)-", 4122, 1, 0.0, 2.285 * d4, d7 / (6.18E-5 * d));
        this.PART("Lambda(b)o", "Lambda(b)o_bar", 5122, 1, 0.0, 5.6415 * d4, 0.0);
        this.PART("B*+", "B*-", 523, 2, 1.0, 5.325 * d4, 0.0);
        this.PART("B*o", "B*o_bar", 513, 2, 0.0, 5.325 * d4, 0.0);
        this.PART("B(s)o", "B(s)o_bar", 531, 0, 0.0, 5.3693 * d4, d7 / (4.83E-4 * d));
        this.PART("B(s)*o", "B(s)*o_bar", 533, 2, 0.0, 5.51 * d4, 0.0);
        this.PART("Xi-", "Xi+", 3312, 1, -1.0, 1.321 * d4, d7 / (0.00491 * d));
        this.PART("Xi(b)-", "Xi(b)+", 5132, 1, -1.0, 6000.0, 6000.0);
        this.PART("Xi(b)*-", "Xi(b)*+", 5314, 2, -1.0, 5.81 * d4, 0.0);
        this.PART("Xi(b)'-", "Xi(b)'+", 5312, 1, -1.0, 5.77 * d4, 0.0);
        this.PART("Xi(b)o", "Xi(b)o_bar", 5232, 1, 0.0, 6.0, 0.0);
        this.PART("Xi(b)*o", "Xi(b)*o_bar", 5324, 2, 0.0, 6.0, 0.0);
        this.PART("Xi(b)'o", "Xi(b)'o_bar", 5322, 1, 0.0, 6.0, 0.0);
        this.PART("Xi(c)+", "Xi(c)-", 4232, 1, 1.0, 2.465 * d4, 0.0);
        this.PART("Xi(c)o", "Xi(c)o_bar", 4132, 1, 0.0, 2.47 * d4, 0.0);
        this.PART("Xi(c)*+", "Xi(c)*-", 4324, 2, 1.0, 2.6446 * d4, 0.0);
        this.PART("Xi(c)*o", "Xi(c)*o_bar", 4314, 2, 0.0, 2.6438 * d4, 0.0);
        this.PART("Xi(c)'+", "Xi(c)'-", 4322, 1, 1.0, 2.465 * d4, 0.0);
        this.PART("Xi(c)'o", "Xi(c)'o_bar", 4312, 1, 0.0, 2.47 * d4, 0.0);
        this.PART("Xi(c0)(1P)", "Xi(c0)(1P)_bar", 10441, 0, 0.0, 3.415 * d4, 13.5 * d5);
        this.PART("Xi(c1)(1P)", "Xi(c1)(1P)_bar", 20443, 2, 0.0, 3.5105 * d4, 0.88 * d5);
        this.PART("Xi(c2)(1P)", "Xi(c)(1P)_bar", 445, 4, 0.0, 3.556 * d4, 2.0 * d5);
        this.PART("Xi(1530)o", "Xi(1530)o_bar", 3324, 3, 0.0, 1.532 * d4, 9.1 * d5);
        this.PART("Sigma(b)-", "Sigma(b)-_bar", 5112, 1, -1.0, 5.812 * d4, 0.0);
        this.PART("Sigma(b)+", "Sigma(b)+_bar", 5222, 1, 1.0, 5.812 * d4, 0.0);
        this.PART("Sigma(b)*+", "Sigma(b)*+_bar", 5224, 2, 1.0, 5.812 * d4, 0.0);
        this.PART("Sigma(b)*-", "Sigma(b)*-_bar", 5114, 2, -1.0, 5.812 * d4, 0.0);
        this.PART("Sigma(b)o", "Sigma(b)o_bar", 5212, 1, 0.0, 1.193 * d4, 0.0);
        this.PART("Sigma(b)*o", "Sigma(b)*o_bar", 5214, 2, 0.0, 1.193 * d4, 0.0);
        this.PART("Sigma(c)+", "Sigma(c)-", 4212, 1, 1.0, 2.453 * d4, 0.0);
        this.PART("Sigma(c)o", "Sigma(c)o_bar", 4112, 1, 0.0, 2.452 * d4, 0.0);
        this.PART("Sigma(c)*o", "Sigma(c)*o_bar", 4114, 2, 0.0, 2.452 * d4, 0.0);
        this.PART("Sigma(c)*+", "Sigma(c)*-", 4214, 2, 1.0, 2.4535 * d4, 0.0);
        this.PART("Sigma(c)++", "Sigma(c)--", 4222, 1, 2.0, 2.453 * d4, 0.0);
        this.PART("Sigma(c)*++", "Sigma(c)*--", 4224, 2, 2.0, 2.455 * d4, 0.0);
        this.PART("Sigma(1385)+", "Sigma(1385)-", 3224, 3, 1.0, 1.383 * d4, 35.8 * d5);
        this.PART("Ko", "Ko_bar", 311, 0, 0.0, 497.672 * d5, 0.0);
        this.PART("K(1410)*o", "K(1410)*o_bar", 100313, 2, 0.0, 1.414 * d4, 227.0 * d5);
        this.PART("K(1410)*+", "K(1410)*-", 100323, 2, 1.0, 1.414 * d4, 227.0 * d5);
        this.PART("K(892)*o", "K*o(892)_bar", 313, 2, 0.0, 896.1 * d5, 50.5 * d5);
        this.PART("K(892)*+", "K*-(892)", 323, 2, 0.0, 891.59 * d5, 49.8 * d5);
        this.PART("K(1270)1o", "K(1270)1o_bar", 10313, 2, 0.0, 1.273 * d4, 90.0 * d5);
        this.PART("K1(1270)+", "K1(1270)-", 10323, 2, 1.0, 1.273 * d4, 90.0 * d5);
        this.PART("K2(1430)*o", "K2(1430)*o_bar", 315, 4, 0.0, 1.4254 * d4, 98.4 * d5);
        this.PART("K2(1430)*+", "K2(1430)*-", 325, 4, 1.0, 1.4254 * d4, 98.4 * d5);
        this.PART("Omega(b)-", "Omega(b)+", 5332, 3, -1.0, 6.0 * d4, 0.0);
        this.PART("Omega(b)*-", "Omega(b)*+", 5334, 4, -1.0, 6.0 * d4, 0.0);
        this.PART("Omega(c)o", "Omega(c)o_bar", 4332, 1, 0.0, 2.704 * d4, 0.0);
        this.PART("Omega(c)*o", "Omega(c)*o_bar", 4334, 2, 0.0, 2.704 * d4, 0.0);
        this.PART("T+", "T-", 611, 0, 1.0, 175.0 * d4, 0.0);
        this.PART("T*+", "T*-", 613, 2, 1.0, 175.14 * d4, 0.0);
        this.PART("To", "To_bar", 621, 0, 0.0, 175.0 * d4, 0.0);
        this.PART("T*o", "T*o_bar", 623, 2, 0.0, 175.14 * d4, 0.0);
        this.PART("W+", "W-", 24, 2, 1.0, 80.33 * d4, 2.07 * d4);
        this.PART("J/psi(1S)", "J/psi(1S)", 443, 2, 0.0, 3.0969 * d4, 87.0 * d6);
        this.PART("sdl-", "sdl+", 1000001, 0, -0.3333333333333333, 100.0 * d4, 0.0);
        this.PART("sul-", "sul+", 1000002, 0, -0.6666666666666666, 100.0 * d4, 0.0);
        this.PART("ssl-", "ssl+", 1000003, 0, -0.3333333333333333, 100.0 * d4, 0.0);
        this.PART("scl-", "scl+", 1000004, 0, -0.6666666666666666, 100.0 * d4, 0.0);
        this.PART("sbl-", "sbl+", 1000005, 0, -0.3333333333333333, 100.0 * d4, 0.0);
        this.PART("stl-", "stl+", 1000006, 0, -0.6666666666666666, 100.0 * d4, 0.0);
        this.PART("sel-", "sel+", 1000011, 0, -1.0, 100.0 * d4, 0.0);
        this.PART("snuel", "snuel_bar", 1000012, 0, 0.0, 100.0 * d4, 0.0);
        this.PART("smul-", "smul+", 1000013, 0, -1.0, 100.0 * d4, 0.0);
        this.PART("snumul", "snumul_bar", 1000014, 0, 0.0, 100.0 * d4, 0.0);
        this.PART("staul-", "staul+", 1000015, 0, -1.0, 100.0 * d4, 0.0);
        this.PART("snutaul", "snutaul_bar", 1000016, 0, 0.0, 100.0 * d4, 0.0);
        this.PART("sdr-", "sdr+", 2000001, 0, -0.3333333333333333, 100.0 * d4, 0.0);
        this.PART("sur-", "sur+", 2000002, 0, -0.6666666666666666, 100.0 * d4, 0.0);
        this.PART("ssr-", "ssr+", 2000003, 0, -0.3333333333333333, 100.0 * d4, 0.0);
        this.PART("scr-", "scr+", 2000004, 0, -0.6666666666666666, 100.0 * d4, 0.0);
        this.PART("sbr-", "sbr+", 2000005, 0, -0.3333333333333333, 100.0 * d4, 0.0);
        this.PART("str-", "str+", 2000006, 0, -0.6666666666666666, 100.0 * d4, 0.0);
        this.PART("ser-", "ser+", 2000011, 0, -1.0, 100.0 * d4, 0.0);
        this.PART("snuer", "snuer_bar", 2000012, 0, 0.0, 100.0 * d4, 0.0);
        this.PART("smur-", "smur+", 2000013, 0, -1.0, 100.0 * d4, 0.0);
        this.PART("snumur", "snumur_bar", 2000014, 0, 0.0, 100.0 * d4, 0.0);
        this.PART("staur-", "staur+", 2000015, 0, -1.0, 100.0 * d4, 0.0);
        this.PART("snutaur", "snutaur_bar", 2000016, 0, 1.0, 100.0 * d4, 0.0);
        this.PART("gluino", 1000021, 1, 0, 0.0);
        this.PART("charg10", "charg10_bar", 1000022, 0, 0.0, 100.0 * d4, 0.0);
        this.PART("charg20", "charg20_bar", 1000023, 0, 0.0, 100.0 * d4, 0.0);
        this.PART("charg1+", "charg1-", 1000024, 0, 1.0, 100.0 * d4, 0.0);
        this.PART("charg30", "charg30_bar", 1000025, 0, 0.0, 100.0 * d4, 0.0);
        this.PART("zino2", "zino2_bar", 1000032, 0, 0.0, 0.0, 0.0);
        this.PART("zino3", "zino3_bar", 1000033, 0, 0.0, 0.0, 0.0);
        this.PART("wino2", "wino2_bar", 1000034, 0, 0.0, 0.0, 0.0);
        this.PART("zino4", "zino4_bar", 1000056, 0, 0.0, 0.0, 0.0);
        this.PART("charg40", "charg40_bar", 1000035, 0, 0.0, 100.0 * d4, 0.0);
        this.PART("charg2+", "charg2-", 1000037, 0, 1.0, 100.0 * d4, 0.0);
        this.PART("gravitino", 1000039, 2, 0, 0.0);
        this.INTERACT("hadronic");
        this.PART("pi+", "pi-", 211, 0, 1.0, 139.5675 * d5, d7 / (7.804 * d));
        this.PART("pi0", 111, 0, 0, 134.9739 * d5, d7 / (2.5E-6 * d2));
        this.PART("K+", "K-", 321, 1, 1.0, 493.646 * d5, d7 / (379.9 * d2));
        this.PART("K0_S", 310, 0, 0, 497.671 * d5, d7 / (2.675 * d2));
        this.PART("K0_L", 130, 0, 0, 497.671 * d5, d7 / (15.5 * d));
        this.PART("rho+", "rho-", 213, 2, 1.0, 768.3 * d5, 149.0 * d5);
        this.PART("rho0", 113, 2, 0, 768.3 * d5, 149.0 * d5);
        this.PART("omega", 223, 2, 0, 781.95 * d5, 8.43 * d5);
        this.PART("phi", 333, 2, 0, 1019.412 * d5, 4.41 * d5);
        this.PART("p", "p_bar", 2212, 1, 1.0, 938.272 * d5);
        this.PART("n", "n_bar", 2112, 1, 0.0, 939.566 * d5);
        this.PART("J/psi", 443, 2, 0, 3097.0 * d5, 0.07 * d5);
        this.PART("Lambda", "Lambda_bar", 3122, 1, 0.0, 1115.63 * d5, d7 / (7.89 * d2));
        this.PART("Sigma+", "Sigma+_bar", 3222, 1, 1.0, 1189.37 * d5, d7 / (2.4 * d2));
        this.PART("Sigma0", "Sigma0_bar", 3212, 1, 0.0, 1192.55 * d5, d7 / (2.2E-9 * d2));
        this.PART("Sigma-", "Sigma-_bar", 3112, 1, -1.0, 1197.43 * d5, d7 / (4.43 * d2));
        this.PART("Sigma0(1385)", "Sigma0(1385)_bar", 3214, 3, 0.0, 1.384 * d4, 36.0 * d5);
        this.PART("Sigma(1385)-", "Sigma(1385)-_bar", 3114, 3, 0.0, 1.3872 * d4, 39.4 * d5);
        this.PART("Xi0", "Xi0_bar", 3322, 1, 0.0, 1314.9 * d5, d7 / (8.69 * d2));
        this.PART("Xi-", "Xi-_bar", 3312, 1, -1.0, 1321.32 * d5, d7 / (4.91 * d2));
        this.PART("Omega-", "Omega-_bar", 3334, 3, -1.0, 1672.43 * d5, d7 / (2.46 * d2));
        this.PART("D+", "D-", 411, 0, 1.0, 1869.3 * d5, d7 / (d * 3.2E-4));
        this.PART("D0", "D0-bar", 421, 0, 0.0, 1864.5 * d5, d7 / (d * 1.259E-4));
        this.PART("D*+", "D*-", 413, 1, 1.0, 2010.1 * d5, 0.5 * d5);
        this.PART("D*0", "D*0-bar", 423, 1, 0.0, 2007.1 * d5, 0.5 * d5);
        this.PART("D(s)+", "D(s)-", 431, 0, 1.0, 1968.8 * d5, 1.46E-12 * d4);
        this.PART("D(s)*+", "D(s)*-", 433, 0, 0.0, 2110.3 * d5);
        this.PART("B+", "B-", 521, 0, 1.0, 5278.6 * d5, d7 / (d * 3.87E-4));
        this.PART("B0", "B0-bar", 511, 0, 0.0, 5278.7 * d5, d7 / (d * 3.87E-4));
        this.PART("upsilon(4S)", 70553, 2, 0, 10.58 * d4, 23.8 * d5);
        this.PART("deutron", 10002, 1, 1, 1876.01 * d5);
        this.PART("triton", 10003, 2, 1, 2809.26 * d5);
        this.PART("alpha", 20001, 0, 2, 3728.17 * d5);
        this.PART("Z0", 33, 2, 0, 91.187 * d4, 2.49 * d4);
        this.PART("Zo", 23, 2, 0, 91.187 * d4, 2.49 * d4);
        this.PART("H0/H02", 35, 0, 0, 300.0 * d4, 1.0 * d4);
        this.PART("h0/H01", 25, 0, 0, 44.0 * d4, 0.0);
        this.PART("H+", 37, 0, 1, 140.0 * d4, 1.0 * d4);
    }

    private void PART(String string, String string2, int n, int n2, double d, double d2, double d3) {
        new Type(string, n, n2, d, d2, d3);
        new Type(string2, -n, n2, -d, d2, d3);
    }

    private void PART(String string, String string2, int n, int n2, double d, double d2) {
        new Type(string, n, n2, d, d2, 0.0);
        new Type(string2, -n, n2, -d, d2, 0.0);
    }

    private void PART(String string, int n, int n2, int n3, double d, double d2) {
        new Type(string, n, n2, n3, d, d2);
    }

    private void PART(String string, int n, int n2, int n3, double d) {
        new Type(string, n, n2, n3, d, 0.0);
    }

    private void INTERACT(String string) {
    }

    public ParticleType get(int n) {
        ParticleType particleType = (ParticleType)this.m_hash.get(new Integer(n));
        if (particleType != null) {
            return particleType;
        }
        return new UnknownType(n);
    }

    public static void main(String[] stringArray) {
        DefaultParticlePropertyProvider defaultParticlePropertyProvider = new DefaultParticlePropertyProvider();
        Enumeration enumeration = defaultParticlePropertyProvider.m_hash.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println(enumeration.nextElement().toString());
        }
    }

    private class Type
    implements ParticleType {
        private String name;
        private int id;
        private int spin;
        private double charge;
        private double mass;
        private double width;
        private NumberFormat format = new DecimalFormat();

        Type(String string, int n, int n2, double d, double d2, double d3) {
            this.name = string;
            this.id = n;
            this.spin = n2;
            this.charge = d;
            this.mass = d2;
            this.width = d3;
            DefaultParticlePropertyProvider.this.m_hash.put(new Integer(n), this);
        }

        public String getName() {
            return this.name;
        }

        public int getPDGID() {
            return this.id;
        }

        public int get2xSpin() {
            return this.spin;
        }

        public double getCharge() {
            return this.charge;
        }

        public double getMass() {
            return this.mass;
        }

        public double getWidth() {
            return this.width;
        }

        public String toString() {
            return this.name + " (mass=" + this.mass + " id=" + this.id + " charge=" + this.format.format(this.charge) + ")";
        }

        public boolean equals(Object object) {
            if (object instanceof ParticleType) {
                ParticleType particleType = (ParticleType)object;
                return Math.abs(this.getPDGID()) == Math.abs(particleType.getPDGID());
            }
            return false;
        }

        public int hashCode() {
            return Math.abs(this.getPDGID());
        }
    }

    private class UnknownType
    implements ParticleType {
        private int id;

        UnknownType(int n) {
            this.id = n;
        }

        public String getName() {
            return "unknown";
        }

        public int getPDGID() {
            return this.id;
        }

        public int get2xSpin() {
            throw new UnknownParticleID(this.id);
        }

        public double getCharge() {
            throw new UnknownParticleID(this.id);
        }

        public double getMass() {
            throw new UnknownParticleID(this.id);
        }

        public double getWidth() {
            throw new UnknownParticleID(this.id);
        }

        public String toString() {
            return "unknown (id=" + this.id + ")";
        }
    }
}

