/*
 * Decompiled with CFR 0.152.
 */
package hep.physics;

import hep.physics.BasicHep3Vector;
import hep.physics.Hep3Vector;
import hep.physics.HepLorentzVector;
import hep.physics.VecOp;
import java.io.Serializable;

public class BasicHepLorentzVector
implements HepLorentzVector,
Serializable {
    private double m_dt;
    private Hep3Vector m_v;
    private boolean m_vIsOwned = false;

    public BasicHepLorentzVector() {
        this.m_dt = 0.0;
        this.m_v = new BasicHep3Vector();
        this.m_vIsOwned = true;
    }

    public BasicHepLorentzVector(double d, double d2, double d3, double d4) {
        this.m_dt = d;
        this.m_v = new BasicHep3Vector(d2, d3, d4);
        this.m_vIsOwned = true;
    }

    public BasicHepLorentzVector(double d, Hep3Vector hep3Vector) {
        this.m_dt = d;
        this.m_v = hep3Vector;
        this.m_vIsOwned = false;
    }

    public void setV3(double d, double d2, double d3, double d4) {
        this.m_dt = d;
        if (this.m_vIsOwned) {
            ((BasicHep3Vector)this.m_v).setV(d2, d3, d4);
        } else {
            this.m_v = new BasicHep3Vector(d2, d3, d4);
            this.m_vIsOwned = true;
        }
    }

    public void setV3(double d, Hep3Vector hep3Vector) {
        this.m_dt = d;
        this.m_v = hep3Vector;
        this.m_vIsOwned = false;
    }

    public void setT(double d) {
        this.m_dt = d;
    }

    public double t() {
        return this.m_dt;
    }

    public Hep3Vector v3() {
        return this.m_v;
    }

    public double lorMag2() {
        return VecOp.dot(this, this);
    }

    public double lorMag() {
        return Math.sqrt(this.lorMag2());
    }
}

