/*
 * Decompiled with CFR 0.152.
 */
package hep.physics;

import hep.physics.Hep3Vector;
import hep.physics.VecOp;
import java.io.Serializable;

public class BasicHep3Vector
implements Hep3Vector,
Serializable {
    private double m_dx;
    private double m_dy;
    private double m_dz;

    public BasicHep3Vector() {
        this.m_dx = 0.0;
        this.m_dy = 0.0;
        this.m_dz = 0.0;
    }

    public BasicHep3Vector(double d, double d2, double d3) {
        this.m_dx = d;
        this.m_dy = d2;
        this.m_dz = d3;
    }

    public BasicHep3Vector(double[] dArray) {
        if (dArray.length != 3) {
            throw new IllegalArgumentException("Illegal array length");
        }
        this.m_dx = dArray[0];
        this.m_dy = dArray[1];
        this.m_dz = dArray[2];
    }

    public void setV(double d, double d2, double d3) {
        this.m_dx = d;
        this.m_dy = d2;
        this.m_dz = d3;
    }

    public double[] v() {
        double[] dArray = new double[]{this.m_dx, this.m_dy, this.m_dz};
        return dArray;
    }

    public double x() {
        return this.m_dx;
    }

    public double y() {
        return this.m_dy;
    }

    public double z() {
        return this.m_dz;
    }

    public double mag() {
        return Math.sqrt(this.mag2());
    }

    public double mag2() {
        return VecOp.dot(this, this);
    }

    public double cosTheta() {
        return this.z() / this.mag();
    }
}

