/*
 * Decompiled with CFR 0.152.
 */
package hep.physics;

import hep.physics.Hep3Matrix;

public class BasicHep3Matrix
implements Hep3Matrix {
    private double[][] m_dmat = new double[3][3];

    public BasicHep3Matrix() {
        int n = 0;
        while (n < 3) {
            int n2 = n;
            while (n2 < 3) {
                this.m_dmat[n][n2] = 0.0;
                ++n2;
            }
            ++n;
        }
    }

    public BasicHep3Matrix(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.m_dmat[0][0] = d;
        this.m_dmat[0][1] = d2;
        this.m_dmat[0][2] = d3;
        this.m_dmat[1][0] = d4;
        this.m_dmat[1][1] = d5;
        this.m_dmat[1][2] = d6;
        this.m_dmat[2][0] = d7;
        this.m_dmat[2][1] = d8;
        this.m_dmat[2][2] = d9;
    }

    public double e(int n, int n2) {
        if (n < 1 | 3 < n) {
            throw new IllegalArgumentException("Row index out of bounds.");
        }
        if (n2 < 1 | 3 < n2) {
            throw new IllegalArgumentException("Column index out of bounds.");
        }
        return this.m_dmat[n - 1][n2 - 1];
    }

    public double det() {
        double d = this.m_dmat[1][1] * this.m_dmat[2][2] - this.m_dmat[1][2] * this.m_dmat[2][1];
        double d2 = this.m_dmat[0][1] * this.m_dmat[2][2] - this.m_dmat[0][2] * this.m_dmat[2][1];
        double d3 = this.m_dmat[0][1] * this.m_dmat[1][2] - this.m_dmat[0][2] * this.m_dmat[1][1];
        return this.m_dmat[0][0] * d - this.m_dmat[1][0] * d2 + this.m_dmat[2][0] * d3;
    }

    public double trace() {
        return this.m_dmat[0][0] + this.m_dmat[1][1] + this.m_dmat[2][2];
    }

    public void setElement(int n, int n2, int n3) {
        if (n < 1 | 3 < n) {
            throw new IllegalArgumentException("Row index out of bounds.");
        }
        if (n2 < 1 | 3 < n2) {
            throw new IllegalArgumentException("Column index out of bounds.");
        }
        this.m_dmat[n - 1][n2 - 1] = n3;
    }

    public void setPassiveEuler(double d, double d2, double d3) {
        double d4 = Math.cos(d2);
        double d5 = Math.sin(d2);
        double d6 = Math.cos(d);
        double d7 = Math.sin(d);
        double d8 = Math.cos(d3);
        double d9 = Math.sin(d3);
        this.m_dmat[0][0] = d8 * d6 - d4 * d7 * d9;
        this.m_dmat[0][1] = d8 * d7 + d4 * d6 * d9;
        this.m_dmat[0][2] = d9 * d5;
        this.m_dmat[1][0] = -d9 * d6 - d4 * d7 * d8;
        this.m_dmat[1][1] = -d9 * d7 + d4 * d6 * d8;
        this.m_dmat[1][2] = d8 * d5;
        this.m_dmat[2][0] = d5 * d7;
        this.m_dmat[2][1] = -d5 * d6;
        this.m_dmat[2][2] = d4;
    }

    public void setActiveEuler(double d, double d2, double d3) {
        double d4 = Math.cos(d2);
        double d5 = Math.sin(d2);
        double d6 = Math.cos(d);
        double d7 = Math.sin(d);
        double d8 = Math.cos(d3);
        double d9 = Math.sin(d3);
        this.m_dmat[0][0] = d8 * d6 - d4 * d7 * d9;
        this.m_dmat[1][0] = d8 * d7 + d4 * d6 * d9;
        this.m_dmat[2][0] = d9 * d5;
        this.m_dmat[0][1] = -d9 * d6 - d4 * d7 * d8;
        this.m_dmat[1][1] = -d9 * d7 + d4 * d6 * d8;
        this.m_dmat[2][1] = d8 * d5;
        this.m_dmat[0][2] = d5 * d7;
        this.m_dmat[1][2] = -d5 * d6;
        this.m_dmat[2][2] = d4;
    }
}

