/*
 * Decompiled with CFR 0.152.
 */
package hep.io.xdr;

import hep.io.xdr.XDRDataInput;
import hep.io.xdr.XDRDataOutput;
import java.io.IOException;
import java.io.RandomAccessFile;

public class XDRRandomAccessFile
extends RandomAccessFile
implements XDRDataInput,
XDRDataOutput {
    public XDRRandomAccessFile(String string, String string2) throws IOException {
        super(string, string2);
    }

    public void writeString(String string) throws IOException {
        this.writeInt(string.length());
        byte[] byArray = string.getBytes();
        this.write(byArray);
        this.pad();
    }

    public void writeStringChars(String string) throws IOException {
        byte[] byArray = string.getBytes();
        this.write(byArray);
        this.pad();
    }

    public void pad() throws IOException {
        int n = (int)(this.getFilePointer() % 4L);
        if (n != 0) {
            this.skipBytes(4 - n);
        }
    }

    public void writeIntArray(int[] nArray) throws IOException {
        this.writeInt(nArray.length);
        int n = 0;
        while (n < nArray.length) {
            this.writeInt(nArray[n]);
            ++n;
        }
    }

    public void writeIntArray(int[] nArray, int n, int n2) throws IOException {
        this.writeInt(n2);
        int n3 = n;
        while (n3 < n2) {
            this.writeInt(nArray[n3]);
            ++n3;
        }
    }

    public void writeDoubleArray(double[] dArray) throws IOException {
        this.writeInt(dArray.length);
        int n = 0;
        while (n < dArray.length) {
            this.writeDouble(dArray[n]);
            ++n;
        }
    }

    public void writeDoubleArray(double[] dArray, int n, int n2) throws IOException {
        this.writeInt(n2);
        int n3 = n;
        while (n3 < n2) {
            this.writeDouble(dArray[n3]);
            ++n3;
        }
    }

    public void writeFloatArray(float[] fArray) throws IOException {
        this.writeInt(fArray.length);
        int n = 0;
        while (n < fArray.length) {
            this.writeFloat(fArray[n]);
            ++n;
        }
    }

    public void writeFloatArray(float[] fArray, int n, int n2) throws IOException {
        this.writeInt(n2);
        int n3 = n;
        while (n3 < n2) {
            this.writeFloat(fArray[n3]);
            ++n3;
        }
    }

    public String readString(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        this.pad();
        return new String(byArray);
    }

    public String readString() throws IOException {
        int n = this.readInt();
        if (n > Short.MAX_VALUE) {
            throw new IOException("String too long: " + n);
        }
        return this.readString(n);
    }

    public int[] readIntArray(int[] nArray) throws IOException {
        int n = this.readInt();
        if (n > Short.MAX_VALUE) {
            throw new IOException("String too long: " + n);
        }
        int[] nArray2 = nArray;
        if (nArray == null || n > nArray.length) {
            nArray2 = new int[n];
        }
        int n2 = 0;
        while (n2 < n) {
            nArray2[n2] = this.readInt();
            ++n2;
        }
        return nArray2;
    }

    public double[] readDoubleArray(double[] dArray) throws IOException {
        int n = this.readInt();
        if (n > Short.MAX_VALUE) {
            throw new IOException("String too long: " + n);
        }
        double[] dArray2 = dArray;
        if (dArray == null || n > dArray.length) {
            dArray2 = new double[n];
        }
        int n2 = 0;
        while (n2 < n) {
            dArray2[n2] = this.readDouble();
            ++n2;
        }
        return dArray2;
    }

    public float[] readFloatArray(float[] fArray) throws IOException {
        int n = this.readInt();
        if (n > Short.MAX_VALUE) {
            throw new IOException("String too long: " + n);
        }
        float[] fArray2 = fArray;
        if (fArray == null || n > fArray.length) {
            fArray2 = new float[n];
        }
        int n2 = 0;
        while (n2 < n) {
            fArray2[n2] = this.readFloat();
            ++n2;
        }
        return fArray2;
    }
}

