/*
 * Decompiled with CFR 0.152.
 */
package hep.io.xdr;

import hep.io.xdr.XDRDataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class XDROutputStream
extends DataOutputStream
implements XDRDataOutput {
    private CountedOutputStream cout;
    private static final byte[] padding = new byte[]{0, 0, 0, 0};

    public XDROutputStream(OutputStream outputStream) {
        super(new CountedOutputStream(outputStream));
        this.cout = (CountedOutputStream)this.out;
    }

    public void writeString(String string) throws IOException {
        this.writeInt(string.length());
        byte[] byArray = string.getBytes();
        this.write(byArray);
        this.pad();
    }

    public void writeStringChars(String string) throws IOException {
        byte[] byArray = string.getBytes();
        this.write(byArray);
        this.pad();
    }

    public void writeIntArray(int[] nArray) throws IOException {
        this.writeInt(nArray.length);
        int n = 0;
        while (n < nArray.length) {
            this.writeInt(nArray[n]);
            ++n;
        }
    }

    public void writeIntArray(int[] nArray, int n, int n2) throws IOException {
        this.writeInt(n2);
        int n3 = n;
        while (n3 < n2) {
            this.writeInt(nArray[n3]);
            ++n3;
        }
    }

    public void writeDoubleArray(double[] dArray) throws IOException {
        this.writeInt(dArray.length);
        int n = 0;
        while (n < dArray.length) {
            this.writeDouble(dArray[n]);
            ++n;
        }
    }

    public void writeDoubleArray(double[] dArray, int n, int n2) throws IOException {
        this.writeInt(n2);
        int n3 = n;
        while (n3 < n2) {
            this.writeDouble(dArray[n3]);
            ++n3;
        }
    }

    public void writeFloatArray(float[] fArray) throws IOException {
        this.writeInt(fArray.length);
        int n = 0;
        while (n < fArray.length) {
            this.writeFloat(fArray[n]);
            ++n;
        }
    }

    public void writeFloatArray(float[] fArray, int n, int n2) throws IOException {
        this.writeInt(n2);
        int n3 = n;
        while (n3 < n2) {
            this.writeFloat(fArray[n3]);
            ++n3;
        }
    }

    public void pad() throws IOException {
        int n = (int)(this.getBytesWritten() % 4L);
        if (n != 0) {
            this.write(padding, 0, 4 - n);
        }
    }

    public long getBytesWritten() {
        return this.cout.getBytesWritten();
    }

    private static final class CountedOutputStream
    extends FilterOutputStream {
        private long count = 0L;

        CountedOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void write(int n) throws IOException {
            super.write(n);
            ++this.count;
        }

        public void write(byte[] byArray) throws IOException {
            super.write(byArray);
            this.count += (long)byArray.length;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            super.write(byArray, n, n2);
            this.count += (long)n2;
        }

        public long getBytesWritten() {
            return this.count;
        }
    }
}

