/*
 * Decompiled with CFR 0.152.
 */
package hep.io.xdr;

import hep.io.xdr.XDRDataInput;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class XDRInputStream
extends DataInputStream
implements XDRDataInput {
    private CountedInputStream cin;

    public XDRInputStream(InputStream inputStream) {
        super(new CountedInputStream(inputStream));
        this.cin = (CountedInputStream)this.in;
    }

    public String readString(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        this.pad();
        return new String(byArray);
    }

    public String readString() throws IOException {
        int n = this.readInt();
        if (n > Short.MAX_VALUE) {
            throw new IOException("String too long: " + n);
        }
        return this.readString(n);
    }

    public int[] readIntArray(int[] nArray) throws IOException {
        int n = this.readInt();
        if (n > Short.MAX_VALUE) {
            throw new IOException("String too long: " + n);
        }
        int[] nArray2 = nArray;
        if (nArray == null || n > nArray.length) {
            nArray2 = new int[n];
        }
        int n2 = 0;
        while (n2 < n) {
            nArray2[n2] = this.readInt();
            ++n2;
        }
        return nArray2;
    }

    public double[] readDoubleArray(double[] dArray) throws IOException {
        int n = this.readInt();
        if (n > Short.MAX_VALUE) {
            throw new IOException("String too long: " + n);
        }
        double[] dArray2 = dArray;
        if (dArray == null || n > dArray.length) {
            dArray2 = new double[n];
        }
        int n2 = 0;
        while (n2 < n) {
            dArray2[n2] = this.readDouble();
            ++n2;
        }
        return dArray2;
    }

    public float[] readFloatArray(float[] fArray) throws IOException {
        int n = this.readInt();
        if (n > Short.MAX_VALUE) {
            throw new IOException("String too long: " + n);
        }
        float[] fArray2 = fArray;
        if (fArray == null || n > fArray.length) {
            fArray2 = new float[n];
        }
        int n2 = 0;
        while (n2 < n) {
            fArray2[n2] = this.readFloat();
            ++n2;
        }
        return fArray2;
    }

    public void pad() throws IOException {
        int n = (int)(this.getBytesRead() % 4L);
        if (n != 0) {
            this.skipBytes(4 - n);
        }
    }

    public long getBytesRead() {
        return this.cin.getBytesRead();
    }

    public void setReadLimit(int n) {
        this.cin.setReadLimit(n);
    }

    public void clearReadLimit() {
        this.cin.clearReadLimit();
    }

    private static final class CountedInputStream
    extends BufferedInputStream {
        private long count = 0L;
        private long mark = 0L;
        private long limit = -1L;

        CountedInputStream(InputStream inputStream) {
            super(inputStream);
        }

        public int read() throws IOException {
            int n = this.checkLimit(1);
            int n2 = super.read();
            if (n2 >= 0) {
                ++this.count;
            }
            return n2;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.checkLimit(n2);
            int n4 = super.read(byArray, n, n3);
            if (n4 > 0) {
                this.count += (long)n4;
            }
            return n4;
        }

        public long skip(long l) throws IOException {
            long l2 = this.checkLimit(l);
            long l3 = super.skip(l2);
            if (l3 > 0L) {
                this.count += l3;
            }
            return l3;
        }

        private int checkLimit(int n) throws IOException {
            if (this.limit < 0L) {
                return n;
            }
            if (this.limit <= this.count) {
                throw new EOFException();
            }
            return Math.min(n, (int)(this.limit - this.count));
        }

        private long checkLimit(long l) throws IOException {
            if (this.limit < 0L) {
                return l;
            }
            if (this.limit <= this.count) {
                throw new EOFException();
            }
            return Math.min(l, this.limit - this.count);
        }

        public int available() throws IOException {
            return Math.min((int)(this.limit - this.count), super.available());
        }

        public synchronized void mark(int n) {
            this.mark = this.count;
            super.mark(n);
        }

        public synchronized void reset() throws IOException {
            this.count = this.mark;
            super.reset();
        }

        public long getBytesRead() {
            return this.count;
        }

        void setReadLimit(int n) {
            this.limit = this.count + (long)n;
        }

        void clearReadLimit() {
            this.limit = -1L;
        }
    }
}

